/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.spi.mount;

import com.google.common.base.Optional;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.md.sal.dom.api.DOMMountPoint;
import org.opendaylight.controller.md.sal.dom.api.DOMService;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public final class SimpleDOMMountPoint
implements DOMMountPoint {
    private final YangInstanceIdentifier identifier;
    private final ClassToInstanceMap<DOMService> services;
    private final SchemaContext schemaContext;

    public static SimpleDOMMountPoint create(YangInstanceIdentifier identifier, ClassToInstanceMap<DOMService> services, SchemaContext ctx) {
        return new SimpleDOMMountPoint(identifier, services, ctx);
    }

    private SimpleDOMMountPoint(YangInstanceIdentifier identifier, ClassToInstanceMap<DOMService> services, SchemaContext ctx) {
        this.identifier = identifier;
        this.services = ImmutableClassToInstanceMap.copyOf(services);
        this.schemaContext = ctx;
    }

    public YangInstanceIdentifier getIdentifier() {
        return this.identifier;
    }

    public SchemaContext getSchemaContext() {
        return this.schemaContext;
    }

    public <T extends DOMService> Optional<T> getService(Class<T> cls) {
        return Optional.fromNullable((Object)this.services.getInstance(cls));
    }

    public Set<Map.Entry<Class<? extends DOMService>, DOMService>> getAllServices() {
        return this.services.entrySet();
    }

    public ClassToInstanceMap<DOMService> getServices() {
        return this.services;
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof DOMMountPoint && this.identifier.equals(((DOMMountPoint)obj).getIdentifier());
    }
}

