/*
 * Decompiled with CFR 0.152.
 */
package rpcbenchmark.impl;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.controller.sal.binding.api.RpcConsumerRegistry;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInputBuilder;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchOutput;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchPayloadService;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.PayloadBuilder;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rpcbenchmark.impl.GlobalBindingRTCClient;
import rpcbenchmark.impl.RTCClient;

public class RoutedBindingRTClient
implements RTCClient {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalBindingRTCClient.class);
    private final RpcbenchPayloadService service;
    private final AtomicLong rpcOk = new AtomicLong(0L);
    private final AtomicLong rpcError = new AtomicLong(0L);
    private final List<RoutedRpcBenchInput> inVal;
    private final int inSize;

    @Override
    public long getRpcOk() {
        return this.rpcOk.get();
    }

    @Override
    public long getRpcError() {
        return this.rpcError.get();
    }

    public RoutedBindingRTClient(RpcConsumerRegistry registry, int inSize, List<InstanceIdentifier<?>> routeIid) {
        this.service = registry != null ? (RpcbenchPayloadService)registry.getRpcService(RpcbenchPayloadService.class) : null;
        this.inSize = inSize;
        this.inVal = new ArrayList<RoutedRpcBenchInput>();
        ArrayList<Payload> listVals = new ArrayList<Payload>();
        for (int i = 0; i < inSize; ++i) {
            listVals.add(new PayloadBuilder().setId(Integer.valueOf(i)).build());
        }
        for (InstanceIdentifier<?> iid : routeIid) {
            this.inVal.add(new RoutedRpcBenchInputBuilder().setNode(iid).setPayload(listVals).build());
        }
    }

    @Override
    public void runTest(int iterations) {
        int rpcOk = 0;
        int rpcError = 0;
        int rpcServerCnt = this.inVal.size();
        for (int i = 0; i < iterations; ++i) {
            RoutedRpcBenchInput input = this.inVal.get(ThreadLocalRandom.current().nextInt(rpcServerCnt));
            ListenableFuture output = this.service.routedRpcBench(input);
            try {
                RpcResult rpcResult = (RpcResult)output.get();
                if (!rpcResult.isSuccessful()) continue;
                List retVal = ((RoutedRpcBenchOutput)rpcResult.getResult()).getPayload();
                if (retVal.size() == this.inSize) {
                    ++rpcOk;
                    continue;
                }
                ++rpcError;
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                ++rpcError;
                LOG.error("Execution failed: ", (Throwable)e);
            }
        }
        this.rpcOk.addAndGet(rpcOk);
        this.rpcError.addAndGet(rpcError);
    }

    @Override
    public void close() {
    }
}

