/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.subsystem.commands;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;
import org.apache.karaf.subsystem.commands.SubsystemSupport;
import org.osgi.service.subsystem.Subsystem;

@Command(scope="subsystem", name="list", description="List all subsystems")
@Service
public class ListAction
extends SubsystemSupport
implements Action {
    public Object execute() throws Exception {
        ShellTable table = new ShellTable();
        table.column("ID").alignRight();
        table.column("SymbolicName");
        table.column("Version");
        table.column("State");
        table.column("Type");
        table.column("Parents");
        table.column("Children");
        for (Subsystem ss : this.getSubsystems()) {
            table.addRow().addContent(new Object[]{ss.getSubsystemId(), ss.getSymbolicName(), ss.getVersion(), ss.getState().toString(), this.getType(ss), this.getSubsytemIds(ss.getParents()), this.getSubsytemIds(ss.getChildren())});
        }
        table.print(System.out);
        return null;
    }

    private String getType(Subsystem subsystem) {
        String type = subsystem.getType();
        if (type.startsWith("osgi.subsystem.")) {
            type = type.substring("osgi.subsystem.".length());
        }
        return type;
    }
}

