/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jms.artemis;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.jms.JMSRuntimeException;
import javax.jms.XAConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQXAConnectionFactory;
import org.apache.activemq.artemis.utils.uri.BeanSupport;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.apache.qpid.jms.util.PropertyUtil;
import org.ops4j.pax.jms.service.ConnectionFactoryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtemisConnectionFactoryFactory
implements ConnectionFactoryFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ArtemisConnectionFactoryFactory.class);

    public ConnectionFactory createConnectionFactory(Map<String, Object> props) throws JMSRuntimeException {
        JmsConnectionFactory cf;
        String url = (String)(props = new HashMap<String, Object>(props)).remove("url");
        if (url == null) {
            throw new JMSRuntimeException("The url property must be set");
        }
        String protocol = (String)props.remove("protocol");
        if ("amqp".equalsIgnoreCase(protocol)) {
            cf = new JmsConnectionFactory(url);
            try {
                Properties properties = new Properties();
                properties.putAll(props);
                PropertyUtil.setProperties((Object)cf, (Properties)properties);
            }
            catch (Exception e) {
                throw (JMSRuntimeException)new JMSRuntimeException("Unable to build Artemis ConnectionFactory").initCause((Throwable)e);
            }
        }
        cf = new ActiveMQConnectionFactory(url);
        try {
            BeanSupport.setData((Object)cf, props);
        }
        catch (Exception e) {
            throw (JMSRuntimeException)new JMSRuntimeException("Unable to build Artemis ConnectionFactory").initCause((Throwable)e);
        }
        return cf;
    }

    public XAConnectionFactory createXAConnectionFactory(Map<String, Object> props) throws JMSRuntimeException {
        String url = (String)(props = new HashMap<String, Object>(props)).remove("url");
        if (url == null) {
            throw new JMSRuntimeException("The url property must be set");
        }
        String protocol = (String)props.remove("protocol");
        if ("amqp".equalsIgnoreCase(protocol)) {
            LOG.warn("XAConnection is not supported when using the amqp protocol. Please check https://issues.apache.org/jira/projects/QPIDJMS/issues/QPIDJMS-206 for more information");
            return null;
        }
        ActiveMQXAConnectionFactory xaCf = new ActiveMQXAConnectionFactory(url);
        try {
            BeanSupport.setData((Object)xaCf, props);
        }
        catch (Exception e) {
            throw (JMSRuntimeException)new JMSRuntimeException("Unable to build Artemis ConnectionFactory").initCause((Throwable)e);
        }
        return xaCf;
    }
}

