/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.zmq;

import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import org.opendaylight.jsonrpc.bus.api.BusSession;
import org.opendaylight.jsonrpc.bus.api.MessageListener;
import org.opendaylight.jsonrpc.bus.api.Publisher;
import org.opendaylight.jsonrpc.bus.api.Requester;
import org.opendaylight.jsonrpc.bus.api.Responder;
import org.opendaylight.jsonrpc.bus.api.Subscriber;
import org.opendaylight.jsonrpc.bus.spi.AbstractBusSessionFactory;
import org.opendaylight.jsonrpc.bus.spi.EventLoopConfiguration;
import org.opendaylight.jsonrpc.bus.zmq.PublisherImpl;
import org.opendaylight.jsonrpc.bus.zmq.RequesterImpl;
import org.opendaylight.jsonrpc.bus.zmq.ResponderImpl;
import org.opendaylight.jsonrpc.bus.zmq.SubscriberImpl;

public class ZmqBusSessionFactory
extends AbstractBusSessionFactory {
    public ZmqBusSessionFactory() {
        super("zmq");
    }

    public ZmqBusSessionFactory(EventLoopConfiguration config) {
        super("zmq", config);
    }

    public Publisher publisher(String uri) {
        DefaultChannelGroup channelGroup = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
        PublisherImpl publisher = new PublisherImpl(uri, this.serverBootstrap, (ChannelGroup)channelGroup, this.handlerExecutor);
        this.addSession((BusSession)publisher);
        return publisher;
    }

    public Subscriber subscriber(String uri, String topic, MessageListener messageListener) {
        SubscriberImpl subscriber = new SubscriberImpl(uri, topic, messageListener, this.clientBootstrap, this.handlerExecutor);
        this.addSession((BusSession)subscriber);
        return subscriber;
    }

    public Requester requester(String uri, MessageListener listener) {
        RequesterImpl requester = new RequesterImpl(uri, this.clientBootstrap, listener, this.handlerExecutor);
        this.addSession((BusSession)requester);
        return requester;
    }

    public Responder responder(String uri, MessageListener listener) {
        DefaultChannelGroup channelGroup = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
        ResponderImpl responder = new ResponderImpl(uri, this.serverBootstrap, listener, (ChannelGroup)channelGroup, this.handlerExecutor);
        this.addSession((BusSession)responder);
        return responder;
    }
}

