/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.zmq;

import io.netty.channel.ChannelHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.concurrent.EventExecutorGroup;
import org.opendaylight.jsonrpc.bus.api.MessageListener;
import org.opendaylight.jsonrpc.bus.api.SessionType;
import org.opendaylight.jsonrpc.bus.zmq.ClientInitializer;
import org.opendaylight.jsonrpc.bus.zmq.TopicSubscriptionHandler;

public class SubscriberInitializer
extends ClientInitializer {
    private final String topic;

    public SubscriberInitializer(String topic, MessageListener listener, EventExecutorGroup handlerExecutor) {
        super(SessionType.SUB, handlerExecutor, listener);
        this.topic = topic;
    }

    @Override
    protected void initChannel(SocketChannel ch) throws Exception {
        super.initChannel(ch);
        ch.pipeline().addAfter("handshake", "topic-init", (ChannelHandler)new TopicSubscriptionHandler(this.topic != null ? this.topic : ""));
    }
}

