/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.zmq;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import org.opendaylight.jsonrpc.bus.api.MessageListener;
import org.opendaylight.jsonrpc.bus.api.PeerContext;
import org.opendaylight.jsonrpc.bus.api.SessionType;
import org.opendaylight.jsonrpc.bus.spi.AbstractMessageListenerAdapter;
import org.opendaylight.jsonrpc.bus.spi.CommonConstants;
import org.opendaylight.jsonrpc.bus.zmq.Constants;
import org.opendaylight.jsonrpc.bus.zmq.Message;
import org.opendaylight.jsonrpc.bus.zmq.PeerContextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerHandler
extends AbstractMessageListenerAdapter<Message> {
    private static final Logger LOG = LoggerFactory.getLogger(ServerHandler.class);
    private boolean first = true;

    public ServerHandler(MessageListener messageListener) {
        super(messageListener);
    }

    protected void channelRead0(ChannelHandlerContext ctx, Message msg) throws Exception {
        PeerContextImpl peer = (PeerContextImpl)((Object)ctx.channel().attr(CommonConstants.ATTR_PEER_CONTEXT).get());
        if (peer.getSocketType() == SessionType.SUB) {
            ByteBuf data = msg.toBuffer();
            if (data.readableBytes() > 1) {
                data.skipBytes(1);
                String topic = data.readCharSequence(data.readableBytes(), StandardCharsets.US_ASCII).toString();
                LOG.info("Subscribing to topic '{}'", (Object)topic);
                ctx.channel().attr(Constants.ATTR_PUBSUB_TOPIC).set((Object)topic);
            }
            this.checkLast(msg);
            return;
        }
        if (peer.getSocketType() == SessionType.REQ && this.first && msg.toBuffer().readableBytes() == 0) {
            LOG.debug("First empty frame discarded : {}", (Object)msg);
        } else {
            this.checkLast(msg);
            this.messageListener.onMessage((PeerContext)peer, msg.toBuffer().toString(StandardCharsets.UTF_8));
        }
    }

    private void checkLast(Message msg) {
        if (msg.last()) {
            this.first = true;
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.error("Caught exception on {}, closing now", (Object)ctx.channel(), (Object)cause);
        ctx.channel().close();
    }
}

