/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.zmq;

import io.netty.bootstrap.Bootstrap;
import io.netty.util.concurrent.DefaultProgressivePromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.concurrent.atomic.AtomicReference;
import org.opendaylight.jsonrpc.bus.api.MessageListener;
import org.opendaylight.jsonrpc.bus.api.RecoverableTransportException;
import org.opendaylight.jsonrpc.bus.api.Requester;
import org.opendaylight.jsonrpc.bus.api.SessionType;
import org.opendaylight.jsonrpc.bus.spi.AbstractChannelInitializer;
import org.opendaylight.jsonrpc.bus.spi.AbstractReconnectingClient;
import org.opendaylight.jsonrpc.bus.spi.CommonConstants;
import org.opendaylight.jsonrpc.bus.zmq.ClientInitializer;
import org.opendaylight.jsonrpc.bus.zmq.Util;

class RequesterImpl
extends AbstractReconnectingClient
implements Requester {
    RequesterImpl(String uri, Bootstrap bootstrap, MessageListener listener, EventExecutorGroup handlerExecutor) {
        super(uri, 10000, bootstrap, (AbstractChannelInitializer)new ClientInitializer(SessionType.REQ, handlerExecutor, listener), SessionType.REQ);
        this.connectInternal();
    }

    public Future<String> send(String message) {
        if (!this.isReady()) {
            throw new RecoverableTransportException(this.sessionType, this.uri.toString());
        }
        DefaultProgressivePromise promise = new DefaultProgressivePromise((EventExecutor)GlobalEventExecutor.INSTANCE);
        ((AtomicReference)this.channelFuture.channel().attr(CommonConstants.ATTR_RESPONSE_QUEUE).get()).set(promise);
        this.channelFuture.channel().writeAndFlush((Object)Util.serializeMessage(message));
        return promise;
    }
}

