/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.zmq;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.jsonrpc.bus.api.SessionType;
import org.opendaylight.jsonrpc.bus.zmq.Command;
import org.opendaylight.jsonrpc.bus.zmq.Util;

public class ReadyCommand
implements Command {
    private final String name;
    private final Map<String, ByteBuf> metadata = new HashMap<String, ByteBuf>();

    public ReadyCommand(ByteBuf buffer) {
        Util.ensureEnoughData(2, buffer);
        byte flags = buffer.readByte();
        if ((flags & 4) == 0) {
            throw new IllegalArgumentException("Expected COMMAND FLAG");
        }
        byte length = buffer.readByte();
        Util.ensureEnoughData(length, buffer);
        byte readyLen = buffer.readByte();
        String readyStr = buffer.readCharSequence((int)readyLen, StandardCharsets.US_ASCII).toString();
        if (!"READY".equals(readyStr)) {
            throw new IllegalArgumentException(String.format("Expected 'READY' string, but got '%s'", readyStr));
        }
        this.name = "READY";
        int read = readyLen + 1;
        while (read < length) {
            byte keyLen = buffer.readByte();
            ++read;
            String mdKey = buffer.readCharSequence((int)keyLen, StandardCharsets.US_ASCII).toString();
            read += keyLen;
            long valLen = buffer.readUnsignedInt();
            read += 4;
            if (valLen == 0L) {
                this.metadata.put(mdKey, Unpooled.EMPTY_BUFFER);
                continue;
            }
            ByteBuf value = Unpooled.buffer((int)((int)valLen));
            buffer.readBytes(value);
            read = (int)((long)read + valLen);
            this.metadata.put(mdKey, value);
        }
    }

    public ReadyCommand(SessionType socketType) {
        this.name = "READY";
        this.metadata.put("Socket-Type", Unpooled.buffer().writeBytes(socketType.name().getBytes(StandardCharsets.US_ASCII)));
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ByteBuf toBuffer() {
        ByteBuf out = Unpooled.buffer();
        out.writeByte(this.name.length());
        out.writeCharSequence((CharSequence)this.name, StandardCharsets.US_ASCII);
        this.emitMetadata(out);
        ByteBuf wrapper = Unpooled.buffer();
        wrapper.writeByte(4);
        wrapper.writeByte(out.writerIndex());
        wrapper.writeBytes(out);
        return wrapper;
    }

    private void emitMetadata(ByteBuf out) {
        for (Map.Entry<String, ByteBuf> md : this.metadata.entrySet()) {
            out.writeByte(md.getKey().length());
            out.writeCharSequence((CharSequence)md.getKey(), StandardCharsets.US_ASCII);
            out.writeInt(md.getValue().readableBytes());
            out.writeBytes(md.getValue());
        }
    }

    public Map<String, ByteBuf> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public String toString() {
        return "ReadyCommand [name=" + this.name + ", metadata=" + this.metadata + "]";
    }
}

