/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.zmq;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelMatcher;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.SocketAddress;
import org.opendaylight.jsonrpc.bus.api.MessageListener;
import org.opendaylight.jsonrpc.bus.api.Publisher;
import org.opendaylight.jsonrpc.bus.api.SessionType;
import org.opendaylight.jsonrpc.bus.spi.AbstractServerSession;
import org.opendaylight.jsonrpc.bus.spi.DiscardingMessageListener;
import org.opendaylight.jsonrpc.bus.zmq.ServerInitializer;
import org.opendaylight.jsonrpc.bus.zmq.TopicChannelMatcher;
import org.opendaylight.jsonrpc.bus.zmq.Util;

class PublisherImpl
extends AbstractServerSession
implements Publisher {
    PublisherImpl(String uri, ServerBootstrap serverBootstrap, ChannelGroup channelGroup, EventExecutorGroup handlerExecutor) {
        super(uri, 10000, channelGroup, SessionType.PUB);
        this.channelFuture = serverBootstrap.childHandler((ChannelHandler)new ServerInitializer(channelGroup, (MessageListener)DiscardingMessageListener.INSTANCE, SessionType.PUB, handlerExecutor)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).bind((SocketAddress)this.address).syncUninterruptibly();
    }

    public void publish(String message, String topic) {
        this.channelGroup.writeAndFlush((Object)Util.serializeMessage(message), (ChannelMatcher)new TopicChannelMatcher(topic));
    }
}

