/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.zmq;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.opendaylight.jsonrpc.bus.spi.CommonConstants;
import org.opendaylight.jsonrpc.bus.zmq.DefaultMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDecoder
extends ByteToMessageDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(MessageDecoder.class);

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (CommonConstants.DEBUG_MODE) {
            LOG.trace("IN {} : Decoding {}", (Object)ctx.channel(), (Object)ByteBufUtil.hexDump((ByteBuf)in));
        }
        in.markReaderIndex();
        byte start = in.readByte();
        switch (start) {
            case 0: 
            case 1: 
            case 4: {
                short len = in.readUnsignedByte();
                if (in.readableBytes() < len) {
                    in.resetReaderIndex();
                    return;
                }
                out.add(this.readObject(in, len, start == 4, start == 0));
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                long len = in.readLong();
                if ((long)in.readableBytes() < len) {
                    in.resetReaderIndex();
                    return;
                }
                out.add(this.readObject(in, (int)len, start == 6, false));
                break;
            }
        }
    }

    private Object readObject(ByteBuf buffer, int len, boolean isCommand, boolean isLastMessage) {
        if (isCommand) {
            throw new UnsupportedOperationException("Not implemented");
        }
        return new DefaultMessage(isLastMessage, buffer.readBytes(len));
    }
}

