/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.zmq;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.StandardCharsets;
import org.opendaylight.jsonrpc.bus.api.SessionType;
import org.opendaylight.jsonrpc.bus.spi.CommonConstants;
import org.opendaylight.jsonrpc.bus.zmq.ByteWrapper;
import org.opendaylight.jsonrpc.bus.zmq.Constants;
import org.opendaylight.jsonrpc.bus.zmq.DefaultMechanism;
import org.opendaylight.jsonrpc.bus.zmq.DefaultServerIndication;
import org.opendaylight.jsonrpc.bus.zmq.HandshakeState;
import org.opendaylight.jsonrpc.bus.zmq.PeerContextImpl;
import org.opendaylight.jsonrpc.bus.zmq.ReadyCommand;
import org.opendaylight.jsonrpc.bus.zmq.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandshakeHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final Logger LOG = LoggerFactory.getLogger(HandshakeHandler.class);
    private HandshakeState state = HandshakeState.SIGNATURE;
    private final byte majorVersion;

    public HandshakeHandler() {
        this(3);
    }

    public HandshakeHandler(byte majorVersion) {
        this.majorVersion = majorVersion;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        ctx.channel().attr(CommonConstants.ATTR_HANDSHAKE_DONE).set((Object)false);
        ctx.channel().write((Object)Constants.DEFAULT_SINATURE);
        ctx.channel().writeAndFlush((Object)new ByteWrapper(this.majorVersion));
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        while (msg.isReadable() && this.state != HandshakeState.DONE) {
            this.readInternal(ctx, msg);
        }
    }

    private void readInternal(ChannelHandlerContext ctx, ByteBuf msg) {
        if (CommonConstants.DEBUG_MODE) {
            LOG.debug("IN {} : {} : {}", new Object[]{ctx.channel(), this.state, ByteBufUtil.hexDump((ByteBuf)msg)});
        }
        SessionType socketType = (SessionType)ctx.channel().attr(CommonConstants.ATTR_SOCKET_TYPE).get();
        switch (this.state) {
            case SIGNATURE: {
                this.processSignature(msg);
                break;
            }
            case VERSION_MAJOR: {
                this.processMajorVersion(ctx, msg, socketType);
                break;
            }
            case SOCKET_TYPE: {
                this.processSocketType(ctx, msg, socketType);
                break;
            }
            case IDENTITY: {
                this.processIdentity(ctx, msg);
                break;
            }
            case MECHANISM: {
                this.processAuthMechanism(ctx, msg, socketType);
                break;
            }
            case READY: {
                this.processReadyCommand(ctx, msg, socketType);
                break;
            }
            case DONE: {
                ctx.fireChannelReadComplete();
                break;
            }
            default: {
                throw new IllegalStateException("FSM error");
            }
        }
    }

    private void processSignature(ByteBuf msg) {
        msg.skipBytes(10);
        this.state = HandshakeState.VERSION_MAJOR;
    }

    private void processSocketType(ChannelHandlerContext ctx, ByteBuf msg, SessionType socketType) {
        ((PeerContextImpl)((Object)ctx.channel().attr(CommonConstants.ATTR_PEER_CONTEXT).get())).setServerSocket(false);
        SessionType remoteSocketType = Constants.getSessionType(msg.readByte());
        ((PeerContextImpl)((Object)ctx.channel().attr(CommonConstants.ATTR_PEER_CONTEXT).get())).setSocketType(remoteSocketType);
        this.ensureSocketType(ctx, socketType, remoteSocketType);
        this.state = HandshakeState.IDENTITY;
    }

    private void ensureSocketType(ChannelHandlerContext ctx, SessionType socketType, SessionType remoteSocketType) {
        if (!Util.assertSocketType(socketType, remoteSocketType)) {
            LOG.warn("Remote socket type '{}' is not allowed to local '{}', closing channel", (Object)remoteSocketType, (Object)socketType);
            ctx.channel().close();
        }
    }

    private void processIdentity(ChannelHandlerContext ctx, ByteBuf msg) {
        msg.skipBytes(2);
        ctx.channel().attr(CommonConstants.ATTR_HANDSHAKE_DONE).set((Object)true);
        ctx.pipeline().remove((ChannelHandler)this);
        LOG.debug("Handshake completed with {}", ctx.channel().attr(CommonConstants.ATTR_PEER_CONTEXT).get());
        ctx.fireUserEventTriggered((Object)"HANDSHAKE_COMPLETED");
        this.state = HandshakeState.DONE;
        if (msg.isReadable()) {
            ctx.fireChannelRead((Object)msg.retain());
        }
    }

    private void processReadyCommand(ChannelHandlerContext ctx, ByteBuf msg, SessionType socketType) {
        ReadyCommand ready = new ReadyCommand(msg);
        if (ready.getMetadata().containsKey("Socket-Type")) {
            String socketTypeStr = ready.getMetadata().get("Socket-Type").toString(StandardCharsets.US_ASCII);
            SessionType remoteSocketType = SessionType.valueOf((String)socketTypeStr);
            this.ensureSocketType(ctx, socketType, remoteSocketType);
            ((PeerContextImpl)((Object)ctx.channel().attr(CommonConstants.ATTR_PEER_CONTEXT).get())).setSocketType(remoteSocketType);
        }
        if (ready.getMetadata().containsKey("Identity")) {
            String identityStr = ready.getMetadata().get("Identity").toString(StandardCharsets.US_ASCII);
            ((PeerContextImpl)((Object)ctx.channel().attr(CommonConstants.ATTR_PEER_CONTEXT).get())).setIdentity(identityStr);
        }
        LOG.trace("Ready command received : {}", (Object)ready);
        this.state = HandshakeState.DONE;
        ctx.channel().attr(CommonConstants.ATTR_HANDSHAKE_DONE).set((Object)true);
        ctx.pipeline().remove((ChannelHandler)this);
        LOG.debug("Handshake completed with {}", ctx.channel().attr(CommonConstants.ATTR_PEER_CONTEXT).get());
        ctx.fireUserEventTriggered((Object)"HANDSHAKE_COMPLETED");
        if (msg.isReadable()) {
            ctx.fireChannelRead((Object)msg.retain());
        }
    }

    private void processAuthMechanism(ChannelHandlerContext ctx, ByteBuf msg, SessionType socketType) {
        msg.skipBytes(1);
        DefaultMechanism mech = new DefaultMechanism(msg);
        if (!Constants.NULL_AUTH.name().equals(mech.name())) {
            LOG.warn("Unsupported mechanism : {}, closing channel", (Object)mech);
            ctx.channel().close();
            ctx.fireExceptionCaught((Throwable)new UnsupportedOperationException());
        }
        LOG.trace("Authentication mechanism : {}", (Object)mech);
        DefaultServerIndication serverInfo = new DefaultServerIndication(msg);
        ((PeerContextImpl)((Object)ctx.channel().attr(CommonConstants.ATTR_PEER_CONTEXT).get())).setServerSocket(serverInfo.isServer());
        this.state = HandshakeState.READY;
        ctx.channel().writeAndFlush((Object)new ReadyCommand(socketType)).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    LOG.warn("Unable to perform handshake, closing {}", (Object)future.channel(), (Object)future.cause());
                    future.channel().close();
                }
            }
        });
    }

    private void processMajorVersion(ChannelHandlerContext ctx, ByteBuf msg, SessionType socketType) {
        byte peerMajorVersion = msg.readByte();
        LOG.debug("Peer {} advertised major version {}", (Object)ctx.channel(), (Object)peerMajorVersion);
        if (peerMajorVersion >= 3) {
            ctx.channel().write((Object)new ByteWrapper(0));
            ctx.channel().write((Object)Constants.NULL_AUTH);
            ctx.channel().writeAndFlush((Object)new DefaultServerIndication(false)).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    HandshakeHandler.this.state = HandshakeState.MECHANISM;
                }
            });
        } else {
            this.state = HandshakeState.SOCKET_TYPE;
            ctx.channel().write((Object)new ByteWrapper(Constants.getZmtp20Socket(socketType)));
            ctx.channel().write((Object)new ByteWrapper(0));
            ctx.channel().write((Object)new ByteWrapper(0));
            ctx.channel().flush();
        }
    }
}

