/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.zmq;

import io.netty.buffer.ByteBuf;
import io.netty.util.internal.StringUtil;
import org.opendaylight.jsonrpc.bus.zmq.Mechanism;
import org.opendaylight.jsonrpc.bus.zmq.Util;

public class DefaultMechanism
implements Mechanism {
    private final String name;

    public DefaultMechanism(String name) {
        if (StringUtil.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("Name must not be empty");
        }
        this.name = name;
    }

    public DefaultMechanism(ByteBuf byteBuf) {
        Util.ensureEnoughData(20, byteBuf);
        StringBuilder sb = new StringBuilder();
        byteBuf.forEachByte(byteBuf.readerIndex(), 20, b -> {
            if (b == 0) {
                return false;
            }
            sb.append((char)(b & 0xFF));
            return true;
        });
        byteBuf.skipBytes(20);
        this.name = sb.toString();
    }

    @Override
    public String name() {
        return this.name;
    }

    public String toString() {
        return "DefaultMechanism [name=" + this.name + "]";
    }
}

