/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.zmq;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opendaylight.jsonrpc.bus.zmq.CompositeMessage;
import org.opendaylight.jsonrpc.bus.zmq.Message;

public class DefaultCompositeMessage
implements CompositeMessage {
    private final List<Message> messages = new ArrayList<Message>();

    public DefaultCompositeMessage(Message ... msgs) {
        this.messages.addAll(Arrays.asList(msgs));
    }

    @Override
    public List<Message> messages() {
        return Collections.unmodifiableList(this.messages);
    }

    @Override
    public ByteBuf toBuffer() {
        ByteBuf buffer = Unpooled.buffer();
        int size = this.messages.size();
        if (size == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (size == 1) {
            this.write(true, this.messages.get(0), buffer);
            return buffer;
        }
        for (int i = 0; i < this.messages.size() - 1; ++i) {
            this.write(false, this.messages.get(i), buffer);
        }
        this.write(true, this.messages.get(size - 1), buffer);
        return buffer;
    }

    private void write(boolean last, Message message, ByteBuf buffer) {
        ByteBuf content = message.toBuffer();
        if (content.readableBytes() > 255) {
            buffer.writeByte(last ? 2 : 3);
            buffer.writeLong((long)content.readableBytes());
        } else {
            buffer.writeByte(last ? 0 : 1);
            buffer.writeByte(content.readableBytes());
        }
        buffer.writeBytes(content);
    }

    public String toString() {
        return "DefaultCompositeMessage [messages=" + this.messages + "]";
    }
}

