/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.zmq;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import io.netty.util.AttributeKey;
import org.opendaylight.jsonrpc.bus.api.SessionType;
import org.opendaylight.jsonrpc.bus.zmq.DefaultMechanism;
import org.opendaylight.jsonrpc.bus.zmq.DefaultSignature;
import org.opendaylight.jsonrpc.bus.zmq.Mechanism;
import org.opendaylight.jsonrpc.bus.zmq.Signature;

public final class Constants {
    private static final BiMap<SessionType, Byte> ZMTP20_SOCKETS = ImmutableBiMap.builder().put((Object)SessionType.PUB, (Object)1).put((Object)SessionType.SUB, (Object)2).put((Object)SessionType.REQ, (Object)3).put((Object)SessionType.REP, (Object)4).build();
    public static final int SIGNATURE_PREFIX = 255;
    public static final int SIGNATURE_SUFFIX = 127;
    public static final byte CURRENT_MAJOR_VERSION = 3;
    public static final byte CURRENT_MINOR_VERSION = 0;
    public static final byte LAST_MESSAGE_SHORT_SIZE = 0;
    public static final byte MESSAGE_SHORT_SIZE = 1;
    public static final byte LAST_MESSAGE_LONG_SIZE = 2;
    public static final byte MESSAGE_LONG_SIZE = 3;
    public static final byte COMMAND_SHORT_SIZE = 4;
    public static final byte COMMAND_LONG_SIZE = 6;
    public static final byte FLAG_COMMAND = 4;
    public static final byte FLAG_LONG_FRAME = 2;
    public static final byte FLAG_MORE = 1;
    public static final String READY_STR = "READY";
    public static final String METADATA_SOCKET_TYPE = "Socket-Type";
    public static final String METADATA_IDENTITY = "Identity";
    public static final Signature DEFAULT_SINATURE = new DefaultSignature();
    public static final Mechanism NULL_AUTH = new DefaultMechanism("NULL");
    public static final AttributeKey<String> ATTR_PUBSUB_TOPIC = AttributeKey.valueOf(Constants.class, (String)"PUBSUB_TOPIC");
    public static final String HANDLER_HANDSHAKE = "handshake";
    public static final String HANDLER_CLIENT = "client";
    public static final String HANDLER_ENCODER = "decoder";
    public static final String HANDLER_DECODER = "encoder";
    public static final String HANDLER_SUBSCRIBER_INITIALIZER = "topic-init";
    public static final String HANDSHAKE_COMPLETED = "HANDSHAKE_COMPLETED";
    public static final String TRANSPORT_NAME = "zmq";

    public static byte getZmtp20Socket(SessionType sessionType) {
        return (Byte)ZMTP20_SOCKETS.get((Object)sessionType);
    }

    public static SessionType getSessionType(byte value) {
        return (SessionType)ZMTP20_SOCKETS.inverse().get((Object)value);
    }

    private Constants() {
    }
}

