/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.zmq;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.concurrent.atomic.AtomicReference;
import org.opendaylight.jsonrpc.bus.api.MessageListener;
import org.opendaylight.jsonrpc.bus.api.SessionType;
import org.opendaylight.jsonrpc.bus.spi.AbstractChannelInitializer;
import org.opendaylight.jsonrpc.bus.spi.CommonConstants;
import org.opendaylight.jsonrpc.bus.zmq.ClientHandler;
import org.opendaylight.jsonrpc.bus.zmq.HandshakeHandler;
import org.opendaylight.jsonrpc.bus.zmq.MessageDecoder;
import org.opendaylight.jsonrpc.bus.zmq.MessageEncoder;
import org.opendaylight.jsonrpc.bus.zmq.PeerContextImpl;

class ClientInitializer
extends AbstractChannelInitializer {
    private final MessageListener listener;

    ClientInitializer(SessionType socketType, EventExecutorGroup handlerExecutor, MessageListener listener) {
        super(socketType, handlerExecutor);
        this.listener = listener;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        super.initChannel(ch);
        ch.attr(CommonConstants.ATTR_RESPONSE_QUEUE).set(new AtomicReference<Object>(null));
        ch.attr(CommonConstants.ATTR_PEER_CONTEXT).set((Object)new PeerContextImpl((Channel)ch));
        ClientInitializer.configureLogging((Channel)ch);
        ch.pipeline().addLast("handshake", (ChannelHandler)new HandshakeHandler());
        ch.pipeline().addLast("encoder", (ChannelHandler)new MessageDecoder());
        ch.pipeline().addLast("decoder", (ChannelHandler)new MessageEncoder());
        ch.pipeline().addLast(this.handlerExecutor, "client", (ChannelHandler)new ClientHandler(this.listener));
    }
}

