/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.yang_version;

import java.util.Optional;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.YangVersionStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.yang_version.YangVersionEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.yang_version.YangVersionStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

public final class YangVersionStatementSupport
extends AbstractStatementSupport<YangVersion, YangVersionStatement, EffectiveStatement<YangVersion, YangVersionStatement>> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.YANG_VERSION).build();
    private static final YangVersionStatementSupport INSTANCE = new YangVersionStatementSupport();

    private YangVersionStatementSupport() {
        super((StatementDefinition)YangStmtMapping.YANG_VERSION);
    }

    public static YangVersionStatementSupport getInstance() {
        return INSTANCE;
    }

    public YangVersion parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return (YangVersion)SourceException.unwrap((Optional)YangVersion.parse((String)value), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Unsupported YANG version %s", (Object[])new Object[]{value});
    }

    public YangVersionStatement createDeclared(StmtContext<YangVersion, YangVersionStatement, ?> ctx) {
        return new YangVersionStatementImpl(ctx);
    }

    public void onPreLinkageDeclared(StmtContext.Mutable<YangVersion, YangVersionStatement, EffectiveStatement<YangVersion, YangVersionStatement>> stmt) {
        stmt.setRootVersion((YangVersion)stmt.getStatementArgument());
    }

    public EffectiveStatement<YangVersion, YangVersionStatement> createEffective(StmtContext<YangVersion, YangVersionStatement, EffectiveStatement<YangVersion, YangVersionStatement>> ctx) {
        return new YangVersionEffectiveStatementImpl(ctx);
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }
}

