/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.uses;

import java.util.Collection;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.UsesStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.uses.UsesEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.uses.UsesStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.GroupingNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;

public final class UsesStatementSupport
extends AbstractQNameStatementSupport<UsesStatement, EffectiveStatement<QName, UsesStatement>> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.USES).addAny((StatementDefinition)YangStmtMapping.AUGMENT).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addAny((StatementDefinition)YangStmtMapping.REFINE).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addOptional((StatementDefinition)YangStmtMapping.WHEN).build();
    private static final UsesStatementSupport INSTANCE = new UsesStatementSupport();

    private UsesStatementSupport() {
        super((StatementDefinition)YangStmtMapping.USES);
    }

    public static UsesStatementSupport getInstance() {
        return INSTANCE;
    }

    public QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseNodeIdentifier(ctx, (String)value);
    }

    public void onFullDefinitionDeclared(final StmtContext.Mutable<QName, UsesStatement, EffectiveStatement<QName, UsesStatement>> usesNode) {
        if (!usesNode.isSupportedByFeatures()) {
            return;
        }
        super.onFullDefinitionDeclared(usesNode);
        ModelActionBuilder usesAction = usesNode.newInferenceAction(ModelProcessingPhase.EFFECTIVE_MODEL);
        final QName groupingName = (QName)usesNode.getStatementArgument();
        final ModelActionBuilder.Prerequisite sourceGroupingPre = usesAction.requiresCtx(usesNode, GroupingNamespace.class, (Object)groupingName, ModelProcessingPhase.EFFECTIVE_MODEL);
        final ModelActionBuilder.Prerequisite targetNodePre = usesAction.mutatesEffectiveCtx(usesNode.getParentContext());
        usesAction.apply(new ModelActionBuilder.InferenceAction(){

            public void apply(ModelActionBuilder.InferenceContext ctx) {
                StatementContextBase targetNodeStmtCtx = (StatementContextBase)targetNodePre.resolve(ctx);
                StatementContextBase sourceGrpStmtCtx = (StatementContextBase)sourceGroupingPre.resolve(ctx);
                UsesStatementImpl.copyFromSourceToTarget(sourceGrpStmtCtx, targetNodeStmtCtx, (StmtContext.Mutable<QName, UsesStatement, EffectiveStatement<QName, UsesStatement>>)usesNode);
                UsesStatementImpl.resolveUsesNode((StmtContext.Mutable<QName, UsesStatement, EffectiveStatement<QName, UsesStatement>>)usesNode, targetNodeStmtCtx);
                StmtContextUtils.validateIfFeatureAndWhenOnListKeys((StmtContext)usesNode);
            }

            public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                InferenceException.throwIf((boolean)failed.contains(sourceGroupingPre), (StatementSourceReference)usesNode.getStatementSourceReference(), (String)"Grouping '%s' was not resolved.", (Object[])new Object[]{groupingName});
                throw new InferenceException("Unknown error occurred.", usesNode.getStatementSourceReference());
            }
        });
    }

    public UsesStatement createDeclared(StmtContext<QName, UsesStatement, ?> ctx) {
        return new UsesStatementImpl(ctx);
    }

    public EffectiveStatement<QName, UsesStatement> createEffective(StmtContext<QName, UsesStatement, EffectiveStatement<QName, UsesStatement>> ctx) {
        return new UsesEffectiveStatementImpl(ctx);
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }
}

