/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.uses;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.RefineStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.UsesStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.namespace.ChildSchemaNodeNamespace;
import org.opendaylight.yangtools.yang.parser.rfc7950.reactor.YangValidationBundles;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractDeclaredStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleCtxToModuleQName;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.spi.validation.ValidationBundlesNamespace;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UsesStatementImpl
extends AbstractDeclaredStatement<QName>
implements UsesStatement {
    private static final Logger LOG = LoggerFactory.getLogger(UsesStatementImpl.class);
    private static final ImmutableSet<YangStmtMapping> TOP_REUSED_DEF_SET = ImmutableSet.of((Object)YangStmtMapping.TYPE, (Object)YangStmtMapping.TYPEDEF);
    private static final ImmutableSet<YangStmtMapping> NOCOPY_FROM_GROUPING_SET = ImmutableSet.of((Object)YangStmtMapping.DESCRIPTION, (Object)YangStmtMapping.REFERENCE, (Object)YangStmtMapping.STATUS);
    private static final ImmutableSet<YangStmtMapping> REUSED_DEF_SET = ImmutableSet.of((Object)YangStmtMapping.TYPE, (Object)YangStmtMapping.TYPEDEF, (Object)YangStmtMapping.USES);
    private static final ImmutableSet<YangStmtMapping> ALLOWED_TO_ADD_BY_REFINE_DEF_SET = ImmutableSet.of((Object)YangStmtMapping.MUST);

    UsesStatementImpl(StmtContext<QName, UsesStatement, ?> context) {
        super(context);
    }

    static void copyFromSourceToTarget(StmtContext.Mutable<?, ?, ?> sourceGrpStmtCtx, StatementContextBase<?, ?, ?> targetCtx, StmtContext.Mutable<QName, UsesStatement, EffectiveStatement<QName, UsesStatement>> usesNode) {
        Collection declared = sourceGrpStmtCtx.mutableDeclaredSubstatements();
        Collection effective = sourceGrpStmtCtx.mutableEffectiveSubstatements();
        ArrayList buffer = new ArrayList(declared.size() + effective.size());
        QNameModule newQNameModule = UsesStatementImpl.getNewQNameModule(targetCtx, sourceGrpStmtCtx);
        for (StmtContext.Mutable original : declared) {
            if (!original.isSupportedByFeatures()) continue;
            UsesStatementImpl.copyStatement(original, targetCtx, newQNameModule, buffer);
        }
        for (StmtContext.Mutable original : effective) {
            UsesStatementImpl.copyStatement(original, targetCtx, newQNameModule, buffer);
        }
        targetCtx.addEffectiveSubstatements(buffer);
        usesNode.addAsEffectOfStatement(buffer);
    }

    private static void copyStatement(StmtContext.Mutable<?, ?, ?> original, StatementContextBase<?, ?, ?> targetCtx, QNameModule targetModule, Collection<StmtContext.Mutable<?, ?, ?>> buffer) {
        if (UsesStatementImpl.needToCopyByUses(original)) {
            StmtContext.Mutable copy = targetCtx.childCopyOf(original, CopyType.ADDED_BY_USES, targetModule);
            buffer.add(copy);
        } else if (UsesStatementImpl.isReusedByUsesOnTop(original)) {
            buffer.add(original);
        }
    }

    private static boolean isReusedByUsesOnTop(StmtContext<?, ?, ?> stmtContext) {
        return TOP_REUSED_DEF_SET.contains((Object)stmtContext.getPublicDefinition());
    }

    public static boolean needToCopyByUses(StmtContext<?, ?, ?> stmtContext) {
        StatementDefinition def = stmtContext.getPublicDefinition();
        if (REUSED_DEF_SET.contains((Object)def)) {
            LOG.trace("Will reuse {} statement {}", (Object)def, stmtContext);
            return false;
        }
        if (NOCOPY_FROM_GROUPING_SET.contains((Object)def)) {
            return !YangStmtMapping.GROUPING.equals((Object)stmtContext.coerceParentContext().getPublicDefinition());
        }
        LOG.trace("Will copy {} statement {}", (Object)def, stmtContext);
        return true;
    }

    public static void resolveUsesNode(StmtContext.Mutable<QName, UsesStatement, EffectiveStatement<QName, UsesStatement>> usesNode, StmtContext<?, ?, ?> targetNodeStmtCtx) {
        for (StmtContext.Mutable subStmtCtx : usesNode.mutableDeclaredSubstatements()) {
            if (!StmtContextUtils.producesDeclared((StmtContext)subStmtCtx, RefineStatement.class) || !UsesStatementImpl.areFeaturesSupported(subStmtCtx)) continue;
            UsesStatementImpl.performRefine(subStmtCtx, targetNodeStmtCtx);
        }
    }

    private static boolean areFeaturesSupported(StmtContext<?, ?, ?> subStmtCtx) {
        return !YangVersion.VERSION_1_1.equals((Object)subStmtCtx.getRootVersion()) || subStmtCtx.isSupportedByFeatures();
    }

    private static void performRefine(StmtContext.Mutable<?, ?, ?> subStmtCtx, StmtContext<?, ?, ?> usesParentCtx) {
        Object refineArgument = subStmtCtx.getStatementArgument();
        InferenceException.throwIf((!(refineArgument instanceof SchemaNodeIdentifier) ? 1 : 0) != 0, (StatementSourceReference)subStmtCtx.getStatementSourceReference(), (String)"Invalid refine argument %s. It must be instance of SchemaNodeIdentifier.", (Object[])new Object[]{refineArgument});
        Optional<StmtContext<?, ?, ?>> optRefineTargetCtx = ChildSchemaNodeNamespace.findNode(usesParentCtx, (SchemaNodeIdentifier)refineArgument);
        InferenceException.throwIf((!optRefineTargetCtx.isPresent() ? 1 : 0) != 0, (StatementSourceReference)subStmtCtx.getStatementSourceReference(), (String)"Refine target node %s not found.", (Object[])new Object[]{refineArgument});
        StmtContext<?, ?, ?> refineTargetNodeCtx = optRefineTargetCtx.get();
        if (StmtContextUtils.isUnknownStatement(refineTargetNodeCtx)) {
            LOG.trace("Refine node '{}' in uses '{}' has target node unknown statement '{}'. Refine has been skipped. At line: {}", new Object[]{subStmtCtx.getStatementArgument(), subStmtCtx.coerceParentContext().getStatementArgument(), refineTargetNodeCtx.getStatementArgument(), subStmtCtx.getStatementSourceReference()});
            subStmtCtx.addAsEffectOfStatement(refineTargetNodeCtx);
            return;
        }
        Verify.verify((boolean)(refineTargetNodeCtx instanceof StatementContextBase));
        UsesStatementImpl.addOrReplaceNodes(subStmtCtx, (StatementContextBase)refineTargetNodeCtx);
        subStmtCtx.addAsEffectOfStatement(refineTargetNodeCtx);
    }

    private static void addOrReplaceNodes(StmtContext.Mutable<?, ?, ?> subStmtCtx, StatementContextBase<?, ?, ?> refineTargetNodeCtx) {
        for (StmtContext.Mutable refineSubstatementCtx : subStmtCtx.mutableDeclaredSubstatements()) {
            if (!UsesStatementImpl.isSupportedRefineSubstatement(refineSubstatementCtx)) continue;
            UsesStatementImpl.addOrReplaceNode(refineSubstatementCtx, refineTargetNodeCtx);
        }
    }

    private static void addOrReplaceNode(StmtContext.Mutable<?, ?, ?> refineSubstatementCtx, StatementContextBase<?, ?, ?> refineTargetNodeCtx) {
        StatementDefinition refineSubstatementDef = refineSubstatementCtx.getPublicDefinition();
        SourceException.throwIf((!UsesStatementImpl.isSupportedRefineTarget(refineSubstatementCtx, refineTargetNodeCtx) ? 1 : 0) != 0, (StatementSourceReference)refineSubstatementCtx.getStatementSourceReference(), (String)"Error in module '%s' in the refine of uses '%s': can not perform refine of '%s' for the target '%s'.", (Object[])new Object[]{refineSubstatementCtx.getRoot().getStatementArgument(), refineSubstatementCtx.coerceParentContext().getStatementArgument(), refineSubstatementCtx.getPublicDefinition(), refineTargetNodeCtx.getPublicDefinition()});
        if (UsesStatementImpl.isAllowedToAddByRefine(refineSubstatementDef)) {
            refineTargetNodeCtx.addEffectiveSubstatement(refineSubstatementCtx);
        } else {
            refineTargetNodeCtx.removeStatementFromEffectiveSubstatements(refineSubstatementDef);
            refineTargetNodeCtx.addEffectiveSubstatement(refineSubstatementCtx);
        }
    }

    private static boolean isAllowedToAddByRefine(StatementDefinition publicDefinition) {
        return ALLOWED_TO_ADD_BY_REFINE_DEF_SET.contains((Object)publicDefinition);
    }

    private static boolean isSupportedRefineSubstatement(StmtContext<?, ?, ?> refineSubstatementCtx) {
        Collection supportedRefineSubstatements = (Collection)refineSubstatementCtx.getFromNamespace(ValidationBundlesNamespace.class, (Object)ValidationBundlesNamespace.ValidationBundleType.SUPPORTED_REFINE_SUBSTATEMENTS);
        return supportedRefineSubstatements == null || supportedRefineSubstatements.isEmpty() || supportedRefineSubstatements.contains(refineSubstatementCtx.getPublicDefinition()) || StmtContextUtils.isUnknownStatement(refineSubstatementCtx);
    }

    private static boolean isSupportedRefineTarget(StmtContext<?, ?, ?> refineSubstatementCtx, StmtContext<?, ?, ?> refineTargetNodeCtx) {
        Collection supportedRefineTargets = YangValidationBundles.SUPPORTED_REFINE_TARGETS.get(refineSubstatementCtx.getPublicDefinition());
        return supportedRefineTargets == null || supportedRefineTargets.isEmpty() || supportedRefineTargets.contains(refineTargetNodeCtx.getPublicDefinition());
    }

    private static QNameModule getNewQNameModule(StmtContext<?, ?, ?> targetCtx, StmtContext<?, ?, ?> stmtContext) {
        if (targetCtx.getParentContext() == null) {
            return (QNameModule)targetCtx.getFromNamespace(ModuleCtxToModuleQName.class, targetCtx);
        }
        if (targetCtx.getPublicDefinition() == YangStmtMapping.AUGMENT) {
            return StmtContextUtils.getRootModuleQName(targetCtx);
        }
        Object targetStmtArgument = targetCtx.getStatementArgument();
        Object sourceStmtArgument = stmtContext.getStatementArgument();
        if (targetStmtArgument instanceof QName && sourceStmtArgument instanceof QName) {
            return ((QName)targetStmtArgument).getModule();
        }
        return null;
    }
}

