/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.uses;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.UsesEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UsesStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.WhenEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveDocumentedNode;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.refine.RefineEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.GroupingNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

final class UsesEffectiveStatementImpl
extends AbstractEffectiveDocumentedNode<QName, UsesStatement>
implements UsesEffectiveStatement,
UsesNode {
    private final @NonNull SchemaPath groupingPath;
    private final boolean addedByUses;
    private final @NonNull ImmutableMap<SchemaPath, SchemaNode> refines;
    private final @NonNull ImmutableSet<AugmentationSchemaNode> augmentations;
    private final @NonNull ImmutableList<UnknownSchemaNode> unknownNodes;
    private final @Nullable RevisionAwareXPath whenCondition;

    UsesEffectiveStatementImpl(StmtContext<QName, UsesStatement, EffectiveStatement<QName, UsesStatement>> ctx) {
        super(ctx);
        StmtContext grpCtx = (StmtContext)ctx.getFromNamespace(GroupingNamespace.class, ctx.coerceStatementArgument());
        this.groupingPath = (SchemaPath)grpCtx.getSchemaPath().get();
        this.addedByUses = ctx.getCopyHistory().contains(CopyType.ADDED_BY_USES);
        ArrayList<UnknownSchemaNode> unknownNodesInit = new ArrayList<UnknownSchemaNode>();
        LinkedHashSet<AugmentationSchemaNode> augmentationsInit = new LinkedHashSet<AugmentationSchemaNode>();
        HashMap<SchemaPath, SchemaNode> refinesInit = new HashMap<SchemaPath, SchemaNode>();
        for (EffectiveStatement<?, ?> effectiveStatement : this.effectiveSubstatements()) {
            if (effectiveStatement instanceof UnknownSchemaNode) {
                UnknownSchemaNode unknownNode = (UnknownSchemaNode)effectiveStatement;
                unknownNodesInit.add(unknownNode);
            }
            if (effectiveStatement instanceof AugmentationSchemaNode) {
                AugmentationSchemaNode augmentationSchema = (AugmentationSchemaNode)effectiveStatement;
                augmentationsInit.add(augmentationSchema);
            }
            if (!(effectiveStatement instanceof RefineEffectiveStatementImpl)) continue;
            RefineEffectiveStatementImpl refineStmt = (RefineEffectiveStatementImpl)effectiveStatement;
            SchemaNodeIdentifier identifier = (SchemaNodeIdentifier)refineStmt.argument();
            refinesInit.put(identifier.asSchemaPath(), refineStmt.getRefineTargetNode());
        }
        this.unknownNodes = ImmutableList.copyOf(unknownNodesInit);
        this.augmentations = ImmutableSet.copyOf(augmentationsInit);
        this.refines = ImmutableMap.copyOf(refinesInit);
        this.whenCondition = this.findFirstEffectiveSubstatementArgument(WhenEffectiveStatement.class).orElse(null);
    }

    public SchemaPath getGroupingPath() {
        return this.groupingPath;
    }

    public Set<AugmentationSchemaNode> getAugmentations() {
        return this.augmentations;
    }

    @Deprecated
    public boolean isAugmenting() {
        return false;
    }

    @Deprecated
    public boolean isAddedByUses() {
        return this.addedByUses;
    }

    public Map<SchemaPath, SchemaNode> getRefines() {
        return this.refines;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownNodes;
    }

    public Optional<RevisionAwareXPath> getWhenCondition() {
        return Optional.ofNullable(this.whenCondition);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.groupingPath);
        result = 31 * result + Objects.hashCode(this.augmentations);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UsesEffectiveStatementImpl other = (UsesEffectiveStatementImpl)obj;
        return Objects.equals(this.groupingPath, other.groupingPath) && Objects.equals(this.augmentations, other.augmentations);
    }

    public String toString() {
        return UsesEffectiveStatementImpl.class.getSimpleName() + "[groupingPath=" + this.groupingPath + "]";
    }
}

