/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import com.google.common.annotations.VisibleForTesting;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.BaseTypes;
import org.opendaylight.yangtools.yang.model.util.type.EnumerationTypeBuilder;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.DeclaredEffectiveStatementBase;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.enum_.EnumEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.EffectiveTypeUtil;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

@VisibleForTesting
public final class EnumSpecificationEffectiveStatement
extends DeclaredEffectiveStatementBase<String, TypeStatement.EnumSpecification>
implements TypeEffectiveStatement<TypeStatement.EnumSpecification> {
    private final @NonNull EnumTypeDefinition typeDefinition;

    EnumSpecificationEffectiveStatement(StmtContext<String, TypeStatement.EnumSpecification, EffectiveStatement<String, TypeStatement.EnumSpecification>> ctx) {
        super(ctx);
        EnumerationTypeBuilder builder = BaseTypes.enumerationTypeBuilder((SchemaPath)((SchemaPath)ctx.getSchemaPath().get()));
        Integer highestValue = null;
        for (EffectiveStatement<?, ?> stmt : this.effectiveSubstatements()) {
            if (stmt instanceof EnumEffectiveStatementImpl) {
                int effectiveValue;
                EnumEffectiveStatementImpl enumSubStmt = (EnumEffectiveStatementImpl)stmt;
                if (enumSubStmt.getDeclaredValue() == null) {
                    if (highestValue != null) {
                        SourceException.throwIf((highestValue == Integer.MAX_VALUE ? 1 : 0) != 0, (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Enum '%s' must have a value statement", (Object[])new Object[]{enumSubStmt});
                        effectiveValue = highestValue + 1;
                    } else {
                        effectiveValue = 0;
                    }
                } else {
                    effectiveValue = enumSubStmt.getDeclaredValue();
                }
                EnumTypeDefinition.EnumPair pair = EffectiveTypeUtil.buildEnumPair(enumSubStmt, effectiveValue);
                if (highestValue == null || highestValue < pair.getValue()) {
                    highestValue = pair.getValue();
                }
                builder.addEnum(pair);
            }
            if (!(stmt instanceof UnknownSchemaNode)) continue;
            builder.addUnknownSchemaNode((UnknownSchemaNode)stmt);
        }
        this.typeDefinition = (EnumTypeDefinition)builder.build();
    }

    public EnumTypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }
}

