/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import com.google.common.annotations.VisibleForTesting;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.BaseTypes;
import org.opendaylight.yangtools.yang.model.util.type.BitsTypeBuilder;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.DeclaredEffectiveStatementBase;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.bit.BitEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.EffectiveTypeUtil;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

@VisibleForTesting
public final class BitsSpecificationEffectiveStatement
extends DeclaredEffectiveStatementBase<String, TypeStatement.BitsSpecification>
implements TypeEffectiveStatement<TypeStatement.BitsSpecification> {
    private final @NonNull BitsTypeDefinition typeDefinition;

    BitsSpecificationEffectiveStatement(StmtContext<String, TypeStatement.BitsSpecification, EffectiveStatement<String, TypeStatement.BitsSpecification>> ctx) {
        super(ctx);
        BitsTypeBuilder builder = BaseTypes.bitsTypeBuilder((SchemaPath)((SchemaPath)ctx.getSchemaPath().get()));
        Long highestPosition = null;
        for (EffectiveStatement<?, ?> stmt : this.effectiveSubstatements()) {
            if (stmt instanceof BitEffectiveStatementImpl) {
                long effectivePos;
                BitEffectiveStatementImpl bitSubStmt = (BitEffectiveStatementImpl)stmt;
                if (bitSubStmt.getDeclaredPosition() == null) {
                    if (highestPosition != null) {
                        SourceException.throwIf((highestPosition == 0xFFFFFFFFL ? 1 : 0) != 0, (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Bit %s must have a position statement", (Object[])new Object[]{bitSubStmt});
                        effectivePos = highestPosition + 1L;
                    } else {
                        effectivePos = 0L;
                    }
                } else {
                    effectivePos = bitSubStmt.getDeclaredPosition();
                }
                BitsTypeDefinition.Bit bit = EffectiveTypeUtil.buildBit(bitSubStmt, effectivePos);
                SourceException.throwIf((bit.getPosition() < 0L && bit.getPosition() > 0xFFFFFFFFL ? 1 : 0) != 0, (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Bit %s has illegal position", (Object[])new Object[]{bit});
                if (highestPosition == null || highestPosition < bit.getPosition()) {
                    highestPosition = bit.getPosition();
                }
                builder.addBit(bit);
            }
            if (!(stmt instanceof UnknownSchemaNode)) continue;
            builder.addUnknownSchemaNode((UnknownSchemaNode)stmt);
        }
        this.typeDefinition = (BitsTypeDefinition)builder.build();
    }

    public BitsTypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }
}

