/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.ConstraintMetaDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.InvalidLengthConstraintException;
import org.opendaylight.yangtools.yang.model.util.type.LengthRestrictedTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.RestrictedTypes;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.DeclaredEffectiveStatementBase;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.length.LengthEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.AbstractTypeStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

final class BinaryTypeEffectiveStatementImpl
extends DeclaredEffectiveStatementBase<String, TypeStatement>
implements TypeEffectiveStatement<TypeStatement> {
    private final @NonNull BinaryTypeDefinition typeDefinition;

    BinaryTypeEffectiveStatementImpl(StmtContext<String, TypeStatement, EffectiveStatement<String, TypeStatement>> ctx, BinaryTypeDefinition baseType) {
        super(ctx);
        LengthRestrictedTypeBuilder builder = RestrictedTypes.newBinaryBuilder((BinaryTypeDefinition)baseType, (SchemaPath)AbstractTypeStatementSupport.typeEffectiveSchemaPath(ctx));
        for (EffectiveStatement<?, ?> stmt : this.effectiveSubstatements()) {
            if (stmt instanceof LengthEffectiveStatementImpl) {
                LengthEffectiveStatementImpl length = (LengthEffectiveStatementImpl)stmt;
                try {
                    builder.setLengthConstraint((ConstraintMetaDefinition)length, (List)length.argument());
                }
                catch (IllegalStateException e) {
                    throw new SourceException(ctx.getStatementSourceReference(), (Throwable)e, "Multiple length constraints encountered", new Object[0]);
                }
                catch (InvalidLengthConstraintException e) {
                    throw new SourceException(ctx.getStatementSourceReference(), (Throwable)e, "Invalid length constraint %s", new Object[]{length.argument()});
                }
            }
            if (!(stmt instanceof UnknownSchemaNode)) continue;
            builder.addUnknownSchemaNode((UnknownSchemaNode)stmt);
        }
        this.typeDefinition = (BinaryTypeDefinition)builder.build();
    }

    public BinaryTypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }
}

