/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.RestrictedTypes;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.BinaryTypeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.BitsSpecificationSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.BitsTypeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.BooleanTypeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.BuiltinEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.BuiltinTypeStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.Decimal64SpecificationSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.DecimalTypeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.EmptyTypeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.EnumSpecificationSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.EnumTypeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.IdentityRefSpecificationRFC6020Support;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.IdentityrefTypeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.InstanceIdentifierSpecificationSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.InstanceIdentifierTypeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.IntegralTypeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.LeafrefSpecificationRFC6020Support;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.LeafrefTypeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.StringTypeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.TypeStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.UnionSpecificationSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.UnionTypeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.TypeNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.QNameCacheNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

abstract class AbstractTypeStatementSupport
extends AbstractStatementSupport<String, TypeStatement, EffectiveStatement<String, TypeStatement>> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.TYPE).addOptional((StatementDefinition)YangStmtMapping.BASE).addAny((StatementDefinition)YangStmtMapping.BIT).addAny((StatementDefinition)YangStmtMapping.ENUM).addOptional((StatementDefinition)YangStmtMapping.FRACTION_DIGITS).addOptional((StatementDefinition)YangStmtMapping.LENGTH).addOptional((StatementDefinition)YangStmtMapping.PATH).addAny((StatementDefinition)YangStmtMapping.PATTERN).addOptional((StatementDefinition)YangStmtMapping.RANGE).addOptional((StatementDefinition)YangStmtMapping.REQUIRE_INSTANCE).addAny((StatementDefinition)YangStmtMapping.TYPE).build();
    static final String BINARY = "binary";
    static final String BITS = "bits";
    static final String BOOLEAN = "boolean";
    static final String DECIMAL64 = "decimal64";
    static final String EMPTY = "empty";
    static final String ENUMERATION = "enumeration";
    static final String IDENTITY_REF = "identityref";
    static final String INSTANCE_IDENTIFIER = "instance-identifier";
    static final String INT8 = "int8";
    static final String INT16 = "int16";
    static final String INT32 = "int32";
    static final String INT64 = "int64";
    static final String LEAF_REF = "leafref";
    static final String STRING = "string";
    static final String UINT8 = "uint8";
    static final String UINT16 = "uint16";
    static final String UINT32 = "uint32";
    static final String UINT64 = "uint64";
    static final String UNION = "union";
    private static final Map<String, String> BUILT_IN_TYPES = ImmutableMap.builder().put((Object)"binary", (Object)"binary").put((Object)"bits", (Object)"bits").put((Object)"boolean", (Object)"boolean").put((Object)"decimal64", (Object)"decimal64").put((Object)"empty", (Object)"empty").put((Object)"enumeration", (Object)"enumeration").put((Object)"identityref", (Object)"identityref").put((Object)"instance-identifier", (Object)"instance-identifier").put((Object)"int8", (Object)"int8").put((Object)"int16", (Object)"int16").put((Object)"int32", (Object)"int32").put((Object)"int64", (Object)"int64").put((Object)"leafref", (Object)"leafref").put((Object)"string", (Object)"string").put((Object)"uint8", (Object)"uint8").put((Object)"uint16", (Object)"uint16").put((Object)"uint32", (Object)"uint32").put((Object)"uint64", (Object)"uint64").put((Object)"union", (Object)"union").build();
    private static final Map<String, StatementSupport<?, ?, ?>> ARGUMENT_SPECIFIC_SUPPORTS = ImmutableMap.builder().put((Object)"bits", (Object)new BitsSpecificationSupport()).put((Object)"decimal64", (Object)new Decimal64SpecificationSupport()).put((Object)"enumeration", (Object)new EnumSpecificationSupport()).put((Object)"identityref", (Object)new IdentityRefSpecificationRFC6020Support()).put((Object)"instance-identifier", (Object)new InstanceIdentifierSpecificationSupport()).put((Object)"leafref", (Object)new LeafrefSpecificationRFC6020Support()).put((Object)"union", (Object)new UnionSpecificationSupport()).build();

    AbstractTypeStatementSupport() {
        super((StatementDefinition)YangStmtMapping.TYPE);
    }

    public final String parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return value;
    }

    public final TypeStatement createDeclared(StmtContext<String, TypeStatement, ?> ctx) {
        return BuiltinTypeStatement.maybeReplace(new TypeStatementImpl(ctx));
    }

    public final TypeEffectiveStatement<TypeStatement> createEffective(StmtContext<String, TypeStatement, EffectiveStatement<String, TypeStatement>> ctx) {
        BuiltinEffectiveStatement typeStmt;
        switch ((String)ctx.coerceStatementArgument()) {
            case "binary": {
                typeStmt = BuiltinEffectiveStatement.BINARY;
                break;
            }
            case "boolean": {
                typeStmt = BuiltinEffectiveStatement.BOOLEAN;
                break;
            }
            case "empty": {
                typeStmt = BuiltinEffectiveStatement.EMPTY;
                break;
            }
            case "instance-identifier": {
                typeStmt = BuiltinEffectiveStatement.INSTANCE_IDENTIFIER;
                break;
            }
            case "int8": {
                typeStmt = BuiltinEffectiveStatement.INT8;
                break;
            }
            case "int16": {
                typeStmt = BuiltinEffectiveStatement.INT16;
                break;
            }
            case "int32": {
                typeStmt = BuiltinEffectiveStatement.INT32;
                break;
            }
            case "int64": {
                typeStmt = BuiltinEffectiveStatement.INT64;
                break;
            }
            case "string": {
                typeStmt = BuiltinEffectiveStatement.STRING;
                break;
            }
            case "uint8": {
                typeStmt = BuiltinEffectiveStatement.UINT8;
                break;
            }
            case "uint16": {
                typeStmt = BuiltinEffectiveStatement.UINT16;
                break;
            }
            case "uint32": {
                typeStmt = BuiltinEffectiveStatement.UINT32;
                break;
            }
            case "uint64": {
                typeStmt = BuiltinEffectiveStatement.UINT64;
                break;
            }
            default: {
                QName qname = StmtContextUtils.parseNodeIdentifier(ctx, (String)((String)ctx.getStatementArgument()));
                StmtContext typedef = (StmtContext)SourceException.throwIfNull((Object)ctx.getFromNamespace(TypeNamespace.class, (Object)qname), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Type '%s' not found", (Object[])new Object[]{qname});
                typeStmt = ((TypedefEffectiveStatement)typedef.buildEffective()).asTypeEffectiveStatement();
            }
        }
        if (ctx.declaredSubstatements().isEmpty() && ctx.effectiveSubstatements().isEmpty()) {
            return typeStmt;
        }
        TypeDefinition baseType = typeStmt.getTypeDefinition();
        if (baseType instanceof BinaryTypeDefinition) {
            return new BinaryTypeEffectiveStatementImpl(ctx, (BinaryTypeDefinition)baseType);
        }
        if (baseType instanceof BitsTypeDefinition) {
            return new BitsTypeEffectiveStatementImpl(ctx, (BitsTypeDefinition)baseType);
        }
        if (baseType instanceof BooleanTypeDefinition) {
            return new BooleanTypeEffectiveStatementImpl(ctx, (BooleanTypeDefinition)baseType);
        }
        if (baseType instanceof DecimalTypeDefinition) {
            return new DecimalTypeEffectiveStatementImpl(ctx, (DecimalTypeDefinition)baseType);
        }
        if (baseType instanceof EmptyTypeDefinition) {
            return new EmptyTypeEffectiveStatementImpl(ctx, (EmptyTypeDefinition)baseType);
        }
        if (baseType instanceof EnumTypeDefinition) {
            return new EnumTypeEffectiveStatementImpl(ctx, (EnumTypeDefinition)baseType);
        }
        if (baseType instanceof IdentityrefTypeDefinition) {
            return new IdentityrefTypeEffectiveStatementImpl(ctx, (IdentityrefTypeDefinition)baseType);
        }
        if (baseType instanceof InstanceIdentifierTypeDefinition) {
            return new InstanceIdentifierTypeEffectiveStatementImpl(ctx, (InstanceIdentifierTypeDefinition)baseType);
        }
        if (baseType instanceof Int8TypeDefinition) {
            return new IntegralTypeEffectiveStatementImpl(ctx, RestrictedTypes.newInt8Builder((Int8TypeDefinition)((Int8TypeDefinition)baseType), (SchemaPath)AbstractTypeStatementSupport.typeEffectiveSchemaPath(ctx)));
        }
        if (baseType instanceof Int16TypeDefinition) {
            return new IntegralTypeEffectiveStatementImpl(ctx, RestrictedTypes.newInt16Builder((Int16TypeDefinition)((Int16TypeDefinition)baseType), (SchemaPath)AbstractTypeStatementSupport.typeEffectiveSchemaPath(ctx)));
        }
        if (baseType instanceof Int32TypeDefinition) {
            return new IntegralTypeEffectiveStatementImpl(ctx, RestrictedTypes.newInt32Builder((Int32TypeDefinition)((Int32TypeDefinition)baseType), (SchemaPath)AbstractTypeStatementSupport.typeEffectiveSchemaPath(ctx)));
        }
        if (baseType instanceof Int64TypeDefinition) {
            return new IntegralTypeEffectiveStatementImpl(ctx, RestrictedTypes.newInt64Builder((Int64TypeDefinition)((Int64TypeDefinition)baseType), (SchemaPath)AbstractTypeStatementSupport.typeEffectiveSchemaPath(ctx)));
        }
        if (baseType instanceof LeafrefTypeDefinition) {
            return new LeafrefTypeEffectiveStatementImpl(ctx, (LeafrefTypeDefinition)baseType);
        }
        if (baseType instanceof StringTypeDefinition) {
            return new StringTypeEffectiveStatementImpl(ctx, (StringTypeDefinition)baseType);
        }
        if (baseType instanceof Uint8TypeDefinition) {
            return new IntegralTypeEffectiveStatementImpl(ctx, RestrictedTypes.newUint8Builder((Uint8TypeDefinition)((Uint8TypeDefinition)baseType), (SchemaPath)AbstractTypeStatementSupport.typeEffectiveSchemaPath(ctx)));
        }
        if (baseType instanceof Uint16TypeDefinition) {
            return new IntegralTypeEffectiveStatementImpl(ctx, RestrictedTypes.newUint16Builder((Uint16TypeDefinition)((Uint16TypeDefinition)baseType), (SchemaPath)AbstractTypeStatementSupport.typeEffectiveSchemaPath(ctx)));
        }
        if (baseType instanceof Uint32TypeDefinition) {
            return new IntegralTypeEffectiveStatementImpl(ctx, RestrictedTypes.newUint32Builder((Uint32TypeDefinition)((Uint32TypeDefinition)baseType), (SchemaPath)AbstractTypeStatementSupport.typeEffectiveSchemaPath(ctx)));
        }
        if (baseType instanceof Uint64TypeDefinition) {
            return new IntegralTypeEffectiveStatementImpl(ctx, RestrictedTypes.newUint64Builder((Uint64TypeDefinition)((Uint64TypeDefinition)baseType), (SchemaPath)AbstractTypeStatementSupport.typeEffectiveSchemaPath(ctx)));
        }
        if (baseType instanceof UnionTypeDefinition) {
            return new UnionTypeEffectiveStatementImpl(ctx, (UnionTypeDefinition)baseType);
        }
        throw new IllegalStateException("Unhandled base type " + baseType);
    }

    public final void onFullDefinitionDeclared(final StmtContext.Mutable<String, TypeStatement, EffectiveStatement<String, TypeStatement>> stmt) {
        super.onFullDefinitionDeclared(stmt);
        if (BUILT_IN_TYPES.containsKey(stmt.getStatementArgument())) {
            return;
        }
        final QName typeQName = StmtContextUtils.parseNodeIdentifier(stmt, (String)((String)stmt.getStatementArgument()));
        ModelActionBuilder typeAction = stmt.newInferenceAction(ModelProcessingPhase.EFFECTIVE_MODEL);
        final ModelActionBuilder.Prerequisite typePrereq = typeAction.requiresCtx(stmt, TypeNamespace.class, (Object)typeQName, ModelProcessingPhase.EFFECTIVE_MODEL);
        typeAction.mutatesEffectiveCtx(stmt.getParentContext());
        typeAction.apply(new ModelActionBuilder.InferenceAction(){

            public void apply(ModelActionBuilder.InferenceContext ctx) {
            }

            public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                InferenceException.throwIf((boolean)failed.contains(typePrereq), (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Type [%s] was not found.", (Object[])new Object[]{typeQName});
            }
        });
    }

    protected final SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    public final String internArgument(String rawArgument) {
        String found = BUILT_IN_TYPES.get(rawArgument);
        return found != null ? found : rawArgument;
    }

    public boolean hasArgumentSpecificSupports() {
        return !ARGUMENT_SPECIFIC_SUPPORTS.isEmpty();
    }

    public StatementSupport<?, ?, ?> getSupportSpecificForArgument(String argument) {
        return ARGUMENT_SPECIFIC_SUPPORTS.get(argument);
    }

    static final SchemaPath typeEffectiveSchemaPath(StmtContext<?, ?, ?> stmtCtx) {
        SchemaPath path = (SchemaPath)stmtCtx.getSchemaPath().get();
        SchemaPath parent = path.getParent();
        QName parentQName = parent.getLastComponent();
        Preconditions.checkArgument((parentQName != null ? 1 : 0) != 0, (String)"Path %s has an empty parent", (Object)path);
        QName qname = (QName)stmtCtx.getFromNamespace(QNameCacheNamespace.class, (Object)QName.create((QName)parentQName, (String)path.getLastComponent().getLocalName()));
        return parent.createChild(qname);
    }
}

