/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.submodule;

import java.util.Optional;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.BelongsToStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleStatement;
import org.opendaylight.yangtools.yang.model.repo.api.RevisionSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.submodule.SubmoduleEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.submodule.SubmoduleStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.SubmoduleNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.BelongsToPrefixToModuleName;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

abstract class AbstractSubmoduleStatementSupport
extends AbstractStatementSupport<String, SubmoduleStatement, EffectiveStatement<String, SubmoduleStatement>> {
    AbstractSubmoduleStatementSupport() {
        super((StatementDefinition)YangStmtMapping.SUBMODULE);
    }

    public final String parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return value;
    }

    public final SubmoduleStatement createDeclared(StmtContext<String, SubmoduleStatement, ?> ctx) {
        return new SubmoduleStatementImpl(ctx);
    }

    public final EffectiveStatement<String, SubmoduleStatement> createEffective(StmtContext<String, SubmoduleStatement, EffectiveStatement<String, SubmoduleStatement>> ctx) {
        return new SubmoduleEffectiveStatementImpl(ctx);
    }

    public final void onPreLinkageDeclared(StmtContext.Mutable<String, SubmoduleStatement, EffectiveStatement<String, SubmoduleStatement>> stmt) {
        stmt.setRootIdentifier((SourceIdentifier)RevisionSourceIdentifier.create((String)((String)stmt.getStatementArgument()), (Optional)StmtContextUtils.getLatestRevision((Iterable)stmt.declaredSubstatements())));
    }

    public final void onLinkageDeclared(StmtContext.Mutable<String, SubmoduleStatement, EffectiveStatement<String, SubmoduleStatement>> stmt) {
        RevisionSourceIdentifier submoduleIdentifier = RevisionSourceIdentifier.create((String)((String)stmt.coerceStatementArgument()), (Optional)StmtContextUtils.getLatestRevision((Iterable)stmt.declaredSubstatements()));
        StmtContext possibleDuplicateSubmodule = (StmtContext)stmt.getFromNamespace(SubmoduleNamespace.class, (Object)submoduleIdentifier);
        if (possibleDuplicateSubmodule != null && possibleDuplicateSubmodule != stmt) {
            throw new SourceException(stmt.getStatementSourceReference(), "Submodule name collision: %s. At %s", new Object[]{stmt.getStatementArgument(), possibleDuplicateSubmodule.getStatementSourceReference()});
        }
        stmt.addContext(SubmoduleNamespace.class, (Object)submoduleIdentifier, stmt);
        String belongsToModuleName = (String)StmtContextUtils.firstAttributeOf((Iterable)stmt.declaredSubstatements(), BelongsToStatement.class);
        StmtContext prefixSubStmtCtx = StmtContextUtils.findFirstDeclaredSubstatement(stmt, (int)0, (Class[])new Class[]{BelongsToStatement.class, PrefixStatement.class});
        SourceException.throwIfNull((Object)prefixSubStmtCtx, (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Prefix of belongsTo statement is missing in submodule [%s]", (Object[])new Object[]{stmt.getStatementArgument()});
        String prefix = (String)prefixSubStmtCtx.getStatementArgument();
        stmt.addToNs(BelongsToPrefixToModuleName.class, (Object)prefix, (Object)belongsToModuleName);
    }
}

