/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.status;

import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.status.StatusEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.status.StatusStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class StatusStatementSupport
extends AbstractStatementSupport<Status, StatusStatement, EffectiveStatement<Status, StatusStatement>> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.STATUS).build();
    private static final StatusStatementSupport INSTANCE = new StatusStatementSupport();

    private StatusStatementSupport() {
        super((StatementDefinition)YangStmtMapping.STATUS);
    }

    public static StatusStatementSupport getInstance() {
        return INSTANCE;
    }

    public Status parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        switch (value) {
            case "current": {
                return Status.CURRENT;
            }
            case "deprecated": {
                return Status.DEPRECATED;
            }
            case "obsolete": {
                return Status.OBSOLETE;
            }
        }
        throw new SourceException(ctx.getStatementSourceReference(), "Invalid status '%s', must be one of 'current', 'deprecated' or 'obsolete'", new Object[]{value});
    }

    public StatusStatement createDeclared(StmtContext<Status, StatusStatement, ?> ctx) {
        return new StatusStatementImpl(ctx);
    }

    public EffectiveStatement<Status, StatusStatement> createEffective(StmtContext<Status, StatusStatement, EffectiveStatement<Status, StatusStatement>> ctx) {
        return new StatusEffectiveStatementImpl(ctx);
    }

    public String internArgument(String rawArgument) {
        if ("current".equals(rawArgument)) {
            return "current";
        }
        if ("deprecated".equals(rawArgument)) {
            return "deprecated";
        }
        if ("obsolete".equals(rawArgument)) {
            return "obsolete";
        }
        return rawArgument;
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }
}

