/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.rpc;

import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.InputStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OutputStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RpcStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.namespace.ChildSchemaNodeNamespace;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.rpc.RpcEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.rpc.RpcStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;

abstract class AbstractRpcStatementSupport
extends AbstractQNameStatementSupport<RpcStatement, EffectiveStatement<QName, RpcStatement>> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.RPC).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.GROUPING).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addOptional((StatementDefinition)YangStmtMapping.INPUT).addOptional((StatementDefinition)YangStmtMapping.OUTPUT).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addAny((StatementDefinition)YangStmtMapping.TYPEDEF).build();

    AbstractRpcStatementSupport() {
        super((StatementDefinition)YangStmtMapping.RPC);
    }

    public final QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseIdentifier(ctx, (String)value);
    }

    public final void onStatementAdded(StmtContext.Mutable<QName, RpcStatement, EffectiveStatement<QName, RpcStatement>> stmt) {
        stmt.coerceParentContext().addToNs(ChildSchemaNodeNamespace.class, stmt.coerceStatementArgument(), stmt);
    }

    public final RpcStatement createDeclared(StmtContext<QName, RpcStatement, ?> ctx) {
        return new RpcStatementImpl(ctx);
    }

    public final EffectiveStatement<QName, RpcStatement> createEffective(StmtContext<QName, RpcStatement, EffectiveStatement<QName, RpcStatement>> ctx) {
        return new RpcEffectiveStatementImpl(ctx);
    }

    public final void onFullDefinitionDeclared(StmtContext.Mutable<QName, RpcStatement, EffectiveStatement<QName, RpcStatement>> stmt) {
        super.onFullDefinitionDeclared(stmt);
        if (StmtContextUtils.findFirstDeclaredSubstatement(stmt, InputStatement.class) == null) {
            ((StatementContextBase)stmt).appendImplicitStatement(this.implictInput());
        }
        if (StmtContextUtils.findFirstDeclaredSubstatement(stmt, OutputStatement.class) == null) {
            ((StatementContextBase)stmt).appendImplicitStatement(this.implictOutput());
        }
    }

    protected final SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    abstract StatementSupport<?, ?, ?> implictInput();

    abstract StatementSupport<?, ?, ?> implictOutput();
}

