/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.position;

import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.PositionStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.position.PositionEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.position.PositionStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class PositionStatementSupport
extends AbstractStatementSupport<Long, PositionStatement, EffectiveStatement<Long, PositionStatement>> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.POSITION).build();
    private static final PositionStatementSupport INSTANCE = new PositionStatementSupport();

    private PositionStatementSupport() {
        super((StatementDefinition)YangStmtMapping.POSITION);
    }

    public static PositionStatementSupport getInstance() {
        return INSTANCE;
    }

    public Long parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new SourceException(String.format("Bit position value %s is not valid integer", value), ctx.getStatementSourceReference(), (Throwable)e);
        }
    }

    public PositionStatement createDeclared(StmtContext<Long, PositionStatement, ?> ctx) {
        return new PositionStatementImpl(ctx);
    }

    public EffectiveStatement<Long, PositionStatement> createEffective(StmtContext<Long, PositionStatement, EffectiveStatement<Long, PositionStatement>> ctx) {
        return new PositionEffectiveStatementImpl(ctx);
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }
}

