/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.module;

import java.net.URI;
import java.util.Optional;
import org.opendaylight.yangtools.concepts.SemVer;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.NamespaceStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixStatement;
import org.opendaylight.yangtools.yang.model.repo.api.RevisionSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SemVerSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.module.ModuleEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.module.ModuleStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.ModuleNamespace;
import org.opendaylight.yangtools.yang.parser.spi.NamespaceToModule;
import org.opendaylight.yangtools.yang.parser.spi.PreLinkageModuleNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.SemanticVersionModuleNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.SemanticVersionNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.ImpPrefixToNamespace;
import org.opendaylight.yangtools.yang.parser.spi.source.ImportPrefixToModuleCtx;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleCtxToModuleQName;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleCtxToSourceIdentifier;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleNameToModuleQName;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleNameToNamespace;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleNamespaceForBelongsTo;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleQNameToModuleName;
import org.opendaylight.yangtools.yang.parser.spi.source.PrefixToModule;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

abstract class AbstractModuleStatementSupport
extends AbstractStatementSupport<String, ModuleStatement, EffectiveStatement<String, ModuleStatement>> {
    AbstractModuleStatementSupport() {
        super((StatementDefinition)YangStmtMapping.MODULE);
    }

    public final String parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return value;
    }

    public final ModuleStatement createDeclared(StmtContext<String, ModuleStatement, ?> ctx) {
        return new ModuleStatementImpl(ctx);
    }

    public final EffectiveStatement<String, ModuleStatement> createEffective(StmtContext<String, ModuleStatement, EffectiveStatement<String, ModuleStatement>> ctx) {
        return new ModuleEffectiveStatementImpl(ctx);
    }

    public final void onPreLinkageDeclared(StmtContext.Mutable<String, ModuleStatement, EffectiveStatement<String, ModuleStatement>> stmt) {
        String moduleName = (String)stmt.getStatementArgument();
        URI moduleNs = (URI)StmtContextUtils.firstAttributeOf((Iterable)stmt.declaredSubstatements(), NamespaceStatement.class);
        SourceException.throwIfNull((Object)moduleNs, (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Namespace of the module [%s] is missing", (Object[])new Object[]{stmt.getStatementArgument()});
        stmt.addToNs(ModuleNameToNamespace.class, (Object)moduleName, (Object)moduleNs);
        String modulePrefix = (String)StmtContextUtils.firstAttributeOf((Iterable)stmt.declaredSubstatements(), PrefixStatement.class);
        SourceException.throwIfNull((Object)modulePrefix, (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Prefix of the module [%s] is missing", (Object[])new Object[]{stmt.getStatementArgument()});
        stmt.addToNs(ImpPrefixToNamespace.class, (Object)modulePrefix, (Object)moduleNs);
        stmt.addContext(PreLinkageModuleNamespace.class, (Object)moduleName, stmt);
        Optional revisionDate = StmtContextUtils.getLatestRevision((Iterable)stmt.declaredSubstatements());
        QNameModule qNameModule = QNameModule.create((URI)moduleNs, (Revision)revisionDate.orElse(null)).intern();
        stmt.addToNs(ModuleCtxToModuleQName.class, stmt, (Object)qNameModule);
        stmt.setRootIdentifier((SourceIdentifier)RevisionSourceIdentifier.create((String)((String)stmt.getStatementArgument()), (Optional)revisionDate));
    }

    public final void onLinkageDeclared(StmtContext.Mutable<String, ModuleStatement, EffectiveStatement<String, ModuleStatement>> stmt) {
        Optional<Object> moduleNs = Optional.ofNullable(StmtContextUtils.firstAttributeOf((Iterable)stmt.declaredSubstatements(), NamespaceStatement.class));
        SourceException.throwIf((!moduleNs.isPresent() ? 1 : 0) != 0, (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Namespace of the module [%s] is missing", (Object[])new Object[]{stmt.getStatementArgument()});
        Optional revisionDate = StmtContextUtils.getLatestRevision((Iterable)stmt.declaredSubstatements());
        QNameModule qNameModule = QNameModule.create((URI)((URI)moduleNs.get()), (Revision)revisionDate.orElse(null)).intern();
        StmtContext possibleDuplicateModule = (StmtContext)stmt.getFromNamespace(NamespaceToModule.class, (Object)qNameModule);
        if (possibleDuplicateModule != null && possibleDuplicateModule != stmt) {
            throw new SourceException(stmt.getStatementSourceReference(), "Module namespace collision: %s. At %s", new Object[]{qNameModule.getNamespace(), possibleDuplicateModule.getStatementSourceReference()});
        }
        RevisionSourceIdentifier moduleIdentifier = RevisionSourceIdentifier.create((String)((String)stmt.getStatementArgument()), (Optional)revisionDate);
        stmt.addContext(ModuleNamespace.class, (Object)moduleIdentifier, stmt);
        stmt.addContext(ModuleNamespaceForBelongsTo.class, (Object)moduleIdentifier.getName(), stmt);
        stmt.addContext(NamespaceToModule.class, (Object)qNameModule, stmt);
        String modulePrefix = (String)StmtContextUtils.firstAttributeOf((Iterable)stmt.declaredSubstatements(), PrefixStatement.class);
        SourceException.throwIfNull((Object)modulePrefix, (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Prefix of the module [%s] is missing", (Object[])new Object[]{stmt.getStatementArgument()});
        stmt.addToNs(PrefixToModule.class, (Object)modulePrefix, (Object)qNameModule);
        stmt.addToNs(ModuleNameToModuleQName.class, stmt.getStatementArgument(), (Object)qNameModule);
        stmt.addToNs(ModuleCtxToModuleQName.class, stmt, (Object)qNameModule);
        stmt.addToNs(ModuleCtxToSourceIdentifier.class, stmt, (Object)moduleIdentifier);
        stmt.addToNs(ModuleQNameToModuleName.class, (Object)qNameModule, stmt.getStatementArgument());
        stmt.addToNs(ImportPrefixToModuleCtx.class, (Object)modulePrefix, stmt);
        if (stmt.isEnabledSemanticVersioning()) {
            AbstractModuleStatementSupport.addToSemVerModuleNamespace(stmt, (SourceIdentifier)moduleIdentifier);
        }
    }

    private static void addToSemVerModuleNamespace(StmtContext.Mutable<String, ModuleStatement, EffectiveStatement<String, ModuleStatement>> stmt, SourceIdentifier moduleIdentifier) {
        String moduleName = (String)stmt.coerceStatementArgument();
        SemVer moduleSemVer = (SemVer)stmt.getFromNamespace(SemanticVersionNamespace.class, stmt);
        SemVerSourceIdentifier id = SemVerSourceIdentifier.create((String)moduleName, (SemVer)moduleSemVer);
        stmt.addToNs(SemanticVersionModuleNamespace.class, (Object)id, stmt);
    }
}

