/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.mandatory;

import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.MandatoryStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.ArgumentUtils;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.mandatory.EmptyMandatoryStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.mandatory.MandatoryEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.mandatory.MandatoryStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

public final class MandatoryStatementSupport
extends AbstractStatementSupport<Boolean, MandatoryStatement, EffectiveStatement<Boolean, MandatoryStatement>> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.MANDATORY).build();
    private static final MandatoryStatementSupport INSTANCE = new MandatoryStatementSupport();

    private MandatoryStatementSupport() {
        super((StatementDefinition)YangStmtMapping.MANDATORY);
    }

    public static MandatoryStatementSupport getInstance() {
        return INSTANCE;
    }

    public Boolean parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return ArgumentUtils.parseBoolean(ctx, value);
    }

    public MandatoryStatement createDeclared(StmtContext<Boolean, MandatoryStatement, ?> ctx) {
        MandatoryStatementImpl ret = new MandatoryStatementImpl(ctx);
        if (EmptyMandatoryStatement.FALSE.equals((Object)ret)) {
            return EmptyMandatoryStatement.FALSE;
        }
        if (EmptyMandatoryStatement.TRUE.equals((Object)ret)) {
            return EmptyMandatoryStatement.TRUE;
        }
        return ret;
    }

    public EffectiveStatement<Boolean, MandatoryStatement> createEffective(StmtContext<Boolean, MandatoryStatement, EffectiveStatement<Boolean, MandatoryStatement>> ctx) {
        MandatoryEffectiveStatementImpl ret = new MandatoryEffectiveStatementImpl(ctx);
        MandatoryStatement declared = (MandatoryStatement)ret.getDeclared();
        if (declared instanceof EmptyMandatoryStatement && ret.effectiveSubstatements().isEmpty()) {
            return ((EmptyMandatoryStatement)declared).toEffective();
        }
        return ret;
    }

    public String internArgument(String rawArgument) {
        return ArgumentUtils.internBoolean(rawArgument);
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }
}

