/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.leaf_list;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.DerivableSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ElementCountConstraint;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.MustDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DefaultEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DescriptionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafListStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OrderedByEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ReferenceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnitsEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.type.ConcreteTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.ConcreteTypes;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveDataSchemaNode;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStmtUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

public final class LeafListEffectiveStatementImpl
extends AbstractEffectiveDataSchemaNode<LeafListStatement>
implements LeafListEffectiveStatement,
LeafListSchemaNode,
DerivableSchemaNode {
    private static final String ORDER_BY_USER_KEYWORD = "user";
    private final TypeDefinition<?> type;
    private final LeafListSchemaNode original;
    private final boolean userOrdered;
    private final @NonNull ImmutableSet<String> defaultValues;
    private final ImmutableSet<MustDefinition> mustConstraints;
    private final ElementCountConstraint elementCountConstraint;

    LeafListEffectiveStatementImpl(StmtContext<QName, LeafListStatement, EffectiveStatement<QName, LeafListStatement>> ctx) {
        super(ctx);
        this.original = ctx.getOriginalCtx().map(StmtContext::buildEffective).orElse(null);
        TypeEffectiveStatement typeStmt = (TypeEffectiveStatement)SourceException.throwIfNull((Object)this.firstSubstatementOfType(TypeEffectiveStatement.class), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Leaf-list is missing a 'type' statement", (Object[])new Object[0]);
        ConcreteTypeBuilder builder = ConcreteTypes.concreteTypeBuilder((TypeDefinition)typeStmt.getTypeDefinition(), (SchemaPath)((SchemaPath)ctx.getSchemaPath().get()));
        ImmutableSet.Builder defaultValuesBuilder = ImmutableSet.builder();
        boolean isUserOrdered = false;
        for (EffectiveStatement<?, ?> stmt : this.effectiveSubstatements()) {
            if (stmt instanceof OrderedByEffectiveStatement) {
                isUserOrdered = ORDER_BY_USER_KEYWORD.equals(stmt.argument());
            }
            if (stmt instanceof DefaultEffectiveStatement) {
                defaultValuesBuilder.add(((DefaultEffectiveStatement)stmt).argument());
                continue;
            }
            if (stmt instanceof DescriptionEffectiveStatement) {
                builder.setDescription((String)((DescriptionEffectiveStatement)stmt).argument());
                continue;
            }
            if (stmt instanceof ReferenceEffectiveStatement) {
                builder.setReference((String)((ReferenceEffectiveStatement)stmt).argument());
                continue;
            }
            if (stmt instanceof StatusEffectiveStatement) {
                builder.setStatus((Status)((StatusEffectiveStatement)stmt).argument());
                continue;
            }
            if (!(stmt instanceof UnitsEffectiveStatement)) continue;
            builder.setUnits((String)((UnitsEffectiveStatement)stmt).argument());
        }
        this.defaultValues = defaultValuesBuilder.build();
        SourceException.throwIf((boolean)EffectiveStmtUtils.hasDefaultValueMarkedWithIfFeature(ctx.getRootVersion(), typeStmt, this.defaultValues), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Leaf-list '%s' has one of its default values '%s' marked with an if-feature statement.", (Object[])new Object[]{ctx.getStatementArgument(), this.defaultValues});
        this.type = builder.build();
        this.userOrdered = isUserOrdered;
        this.elementCountConstraint = EffectiveStmtUtils.createElementCountConstraint(this).orElse(null);
        this.mustConstraints = ImmutableSet.copyOf(this.allSubstatementsOfType(MustDefinition.class));
    }

    public Collection<String> getDefaults() {
        return this.defaultValues;
    }

    public Optional<LeafListSchemaNode> getOriginal() {
        return Optional.ofNullable(this.original);
    }

    public TypeDefinition<?> getType() {
        return this.type;
    }

    public boolean isUserOrdered() {
        return this.userOrdered;
    }

    public Optional<ElementCountConstraint> getElementCountConstraint() {
        return Optional.ofNullable(this.elementCountConstraint);
    }

    public Collection<MustDefinition> getMustConstraints() {
        return this.mustConstraints;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.getQName());
        result = 31 * result + Objects.hashCode(this.getPath());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LeafListEffectiveStatementImpl other = (LeafListEffectiveStatementImpl)obj;
        return Objects.equals(this.getQName(), other.getQName()) && Objects.equals(this.getPath(), other.getPath());
    }

    public String toString() {
        return LeafListEffectiveStatementImpl.class.getSimpleName() + "[" + this.getQName() + "]";
    }
}

