/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.leaf;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.DerivableSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.MustDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DefaultEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DescriptionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MandatoryEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ReferenceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnitsEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.type.ConcreteTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.ConcreteTypes;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveDataSchemaNode;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStmtUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

public final class LeafEffectiveStatementImpl
extends AbstractEffectiveDataSchemaNode<LeafStatement>
implements LeafEffectiveStatement,
LeafSchemaNode,
DerivableSchemaNode {
    private final ImmutableSet<MustDefinition> mustConstraints;
    private final LeafSchemaNode original;
    private final TypeDefinition<?> type;
    private final String defaultStr;
    private final String unitsStr;
    private final boolean mandatory;

    LeafEffectiveStatementImpl(StmtContext<QName, LeafStatement, EffectiveStatement<QName, LeafStatement>> ctx) {
        super(ctx);
        this.original = ctx.getOriginalCtx().map(StmtContext::buildEffective).orElse(null);
        TypeEffectiveStatement typeStmt = (TypeEffectiveStatement)SourceException.throwIfNull((Object)this.firstSubstatementOfType(TypeEffectiveStatement.class), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Leaf is missing a 'type' statement", (Object[])new Object[0]);
        String dflt = null;
        String units = null;
        ConcreteTypeBuilder builder = ConcreteTypes.concreteTypeBuilder((TypeDefinition)typeStmt.getTypeDefinition(), (SchemaPath)((SchemaPath)ctx.getSchemaPath().get()));
        for (EffectiveStatement<?, ?> stmt : this.effectiveSubstatements()) {
            if (stmt instanceof DefaultEffectiveStatement) {
                dflt = (String)((DefaultEffectiveStatement)stmt).argument();
                builder.setDefaultValue(stmt.argument());
                continue;
            }
            if (stmt instanceof DescriptionEffectiveStatement) {
                builder.setDescription((String)((DescriptionEffectiveStatement)stmt).argument());
                continue;
            }
            if (stmt instanceof ReferenceEffectiveStatement) {
                builder.setReference((String)((ReferenceEffectiveStatement)stmt).argument());
                continue;
            }
            if (stmt instanceof StatusEffectiveStatement) {
                builder.setStatus((Status)((StatusEffectiveStatement)stmt).argument());
                continue;
            }
            if (!(stmt instanceof UnitsEffectiveStatement)) continue;
            units = (String)((UnitsEffectiveStatement)stmt).argument();
            builder.setUnits(units);
        }
        SourceException.throwIf((boolean)EffectiveStmtUtils.hasDefaultValueMarkedWithIfFeature(ctx.getRootVersion(), typeStmt, dflt), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Leaf '%s' has default value '%s' marked with an if-feature statement.", (Object[])new Object[]{ctx.getStatementArgument(), dflt});
        this.defaultStr = dflt;
        this.unitsStr = units;
        this.type = builder.build();
        this.mandatory = this.findFirstEffectiveSubstatementArgument(MandatoryEffectiveStatement.class).orElse(Boolean.FALSE);
        this.mustConstraints = ImmutableSet.copyOf(this.allSubstatementsOfType(MustDefinition.class));
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public Optional<LeafSchemaNode> getOriginal() {
        return Optional.ofNullable(this.original);
    }

    public TypeDefinition<?> getType() {
        return this.type;
    }

    public Collection<MustDefinition> getMustConstraints() {
        return this.mustConstraints;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.getQName());
        result = 31 * result + Objects.hashCode(this.getPath());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LeafEffectiveStatementImpl)) {
            return false;
        }
        LeafEffectiveStatementImpl other = (LeafEffectiveStatementImpl)obj;
        return Objects.equals(this.getQName(), other.getQName()) && Objects.equals(this.getPath(), other.getPath());
    }

    public String toString() {
        return LeafEffectiveStatementImpl.class.getSimpleName() + "[qname=" + this.getQName() + ", path=" + this.getPath() + "]";
    }
}

