/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.import_;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.concepts.SemVer;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.stmt.DescriptionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ImportEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ImportStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ReferenceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionDateEffectiveStatement;
import org.opendaylight.yangtools.yang.model.repo.api.SemVerSourceIdentifier;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.DeclaredEffectiveStatementBase;
import org.opendaylight.yangtools.yang.parser.spi.meta.MissingSubstatementException;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.ImportPrefixToSemVerSourceIdentifier;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

final class ImportEffectiveStatementImpl
extends DeclaredEffectiveStatementBase<String, ImportStatement>
implements ImportEffectiveStatement,
ModuleImport {
    private final String moduleName;
    private final Revision revision;
    private final SemVer semVer;
    private final String prefix;
    private final String description;
    private final String reference;

    ImportEffectiveStatementImpl(StmtContext<String, ImportStatement, ?> ctx) {
        super(ctx);
        this.moduleName = (String)ctx.coerceStatementArgument();
        Optional prefixStmt = this.findFirstEffectiveSubstatementArgument(PrefixEffectiveStatement.class);
        MissingSubstatementException.throwIf((!prefixStmt.isPresent() ? 1 : 0) != 0, (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Prefix is mandatory substatement of import statement", (Object[])new Object[0]);
        this.prefix = (String)prefixStmt.get();
        if (!ctx.isEnabledSemanticVersioning()) {
            Optional optRev = this.findFirstEffectiveSubstatementArgument(RevisionDateEffectiveStatement.class);
            this.revision = optRev.isPresent() ? (Revision)optRev.get() : this.getImportedRevision(ctx);
            this.semVer = null;
        } else {
            SemVerSourceIdentifier importedModuleIdentifier = (SemVerSourceIdentifier)ctx.getFromNamespace(ImportPrefixToSemVerSourceIdentifier.class, (Object)this.prefix);
            this.revision = importedModuleIdentifier.getRevision().orElse(null);
            this.semVer = importedModuleIdentifier.getSemanticVersion().orElse(null);
        }
        this.description = this.findFirstEffectiveSubstatementArgument(DescriptionEffectiveStatement.class).orElse(null);
        this.reference = this.findFirstEffectiveSubstatementArgument(ReferenceEffectiveStatement.class).orElse(null);
    }

    private Revision getImportedRevision(StmtContext<String, ImportStatement, ?> ctx) {
        QNameModule importedModule = StmtContextUtils.getModuleQNameByPrefix(ctx, (String)this.prefix);
        SourceException.throwIfNull((Object)importedModule, (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Unable to find import of module %s with prefix %s.", (Object[])new Object[]{this.moduleName, this.prefix});
        return importedModule.getRevision().orElse(null);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public Optional<Revision> getRevision() {
        return Optional.ofNullable(this.revision);
    }

    public Optional<SemVer> getSemanticVersion() {
        return Optional.ofNullable(this.semVer);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Optional<String> getReference() {
        return Optional.ofNullable(this.reference);
    }

    public int hashCode() {
        return Objects.hash(this.moduleName, this.revision, this.prefix, this.semVer, this.description, this.reference);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImportEffectiveStatementImpl other = (ImportEffectiveStatementImpl)obj;
        return Objects.equals(this.moduleName, other.moduleName) && Objects.equals(this.revision, other.revision) && Objects.equals(this.semVer, other.semVer) && Objects.equals(this.prefix, other.prefix) && Objects.equals(this.description, other.description) && Objects.equals(this.reference, other.reference);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("moduleName", (Object)this.getModuleName()).add("revision", (Object)this.revision).add("version", (Object)this.semVer).add("prefix", (Object)this.getPrefix()).add("description", (Object)this.description).add("reference", (Object)this.reference).toString();
    }
}

