/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.deviation;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.model.api.DeviateDefinition;
import org.opendaylight.yangtools.yang.model.api.Deviation;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DescriptionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DeviationEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DeviationStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ReferenceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.DeclaredEffectiveStatementBase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

final class DeviationEffectiveStatementImpl
extends DeclaredEffectiveStatementBase<SchemaNodeIdentifier, DeviationStatement>
implements Deviation,
DeviationEffectiveStatement,
Immutable {
    private final SchemaPath targetPath;
    private final String description;
    private final String reference;
    private final @NonNull ImmutableList<UnknownSchemaNode> unknownSchemaNodes;
    private final ImmutableList<DeviateDefinition> deviateDefinitions;

    DeviationEffectiveStatementImpl(StmtContext<SchemaNodeIdentifier, DeviationStatement, ?> ctx) {
        super(ctx);
        this.targetPath = ((SchemaNodeIdentifier)ctx.getStatementArgument()).asSchemaPath();
        this.deviateDefinitions = ImmutableList.copyOf(this.allSubstatementsOfType(DeviateDefinition.class));
        this.description = this.findFirstEffectiveSubstatementArgument(DescriptionEffectiveStatement.class).orElse(null);
        this.reference = this.findFirstEffectiveSubstatementArgument(ReferenceEffectiveStatement.class).orElse(null);
        ArrayList<UnknownSchemaNode> unknownSchemaNodesInit = new ArrayList<UnknownSchemaNode>();
        for (EffectiveStatement<?, ?> effectiveStatement : this.effectiveSubstatements()) {
            if (!(effectiveStatement instanceof UnknownSchemaNode)) continue;
            unknownSchemaNodesInit.add((UnknownSchemaNode)effectiveStatement);
        }
        this.unknownSchemaNodes = ImmutableList.copyOf(unknownSchemaNodesInit);
    }

    public SchemaPath getTargetPath() {
        return this.targetPath;
    }

    public List<DeviateDefinition> getDeviates() {
        return this.deviateDefinitions;
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Optional<String> getReference() {
        return Optional.ofNullable(this.reference);
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownSchemaNodes;
    }

    public int hashCode() {
        return Objects.hash(this.targetPath, this.deviateDefinitions, this.description, this.reference);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DeviationEffectiveStatementImpl)) {
            return false;
        }
        DeviationEffectiveStatementImpl other = (DeviationEffectiveStatementImpl)obj;
        return Objects.equals(this.targetPath, other.targetPath) && Objects.equals(this.deviateDefinitions, other.deviateDefinitions) && Objects.equals(this.description, other.description) && Objects.equals(this.reference, other.reference);
    }

    public String toString() {
        return DeviationEffectiveStatementImpl.class.getSimpleName() + "[targetPath=" + this.targetPath + ", deviates=" + this.deviateDefinitions + ", description=" + this.description + ", reference=" + this.reference + "]";
    }
}

