/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.config;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.model.api.stmt.ConfigStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.config.EmptyConfigEffectiveStatement;

abstract class EmptyConfigStatement
implements ConfigStatement {
    static final @NonNull ConfigStatement FALSE = new EmptyConfigStatement(){

        public Boolean argument() {
            return Boolean.FALSE;
        }

        @Override
        EffectiveStatement<Boolean, ConfigStatement> toEffective() {
            return EmptyConfigEffectiveStatement.FALSE;
        }
    };
    static final @NonNull ConfigStatement TRUE = new EmptyConfigStatement(){

        public Boolean argument() {
            return Boolean.TRUE;
        }

        @Override
        EffectiveStatement<Boolean, ConfigStatement> toEffective() {
            return EmptyConfigEffectiveStatement.TRUE;
        }
    };

    EmptyConfigStatement() {
    }

    abstract EffectiveStatement<Boolean, ConfigStatement> toEffective();

    public final Collection<? extends DeclaredStatement<?>> declaredSubstatements() {
        return ImmutableList.of();
    }

    public final StatementDefinition statementDefinition() {
        return YangStmtMapping.CONFIG;
    }

    public final String rawArgument() {
        return Boolean.toString(this.getValue());
    }

    public final StatementSource getStatementSource() {
        return StatementSource.DECLARATION;
    }

    public final int hashCode() {
        return Objects.hash(this.statementDefinition(), this.getStatementSource(), this.argument(), this.rawArgument(), this.declaredSubstatements(), this.getValue());
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConfigStatement)) {
            return false;
        }
        ConfigStatement other = (ConfigStatement)obj;
        return this.getValue() == other.getValue() && ((Boolean)this.argument()).equals(other.argument()) && this.rawArgument().equals(other.rawArgument()) && this.statementDefinition().equals(other.statementDefinition()) && this.getStatementSource().equals((Object)other.getStatementSource()) && this.declaredSubstatements().equals(other.declaredSubstatements());
    }
}

