/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.belongs_to;

import java.util.Collection;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.BelongsToStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixStatement;
import org.opendaylight.yangtools.yang.model.repo.api.RevisionSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.belongs_to.BelongsToEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.belongs_to.BelongsToStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.BelongsToModuleContext;
import org.opendaylight.yangtools.yang.parser.spi.source.BelongsToPrefixToModuleCtx;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleNamespaceForBelongsTo;

public final class BelongsToStatementSupport
extends AbstractStatementSupport<String, BelongsToStatement, EffectiveStatement<String, BelongsToStatement>> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.BELONGS_TO).addMandatory((StatementDefinition)YangStmtMapping.PREFIX).build();
    private static final BelongsToStatementSupport INSTANCE = new BelongsToStatementSupport();

    private BelongsToStatementSupport() {
        super((StatementDefinition)YangStmtMapping.BELONGS_TO);
    }

    public static BelongsToStatementSupport getInstance() {
        return INSTANCE;
    }

    public String parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return value;
    }

    public BelongsToStatement createDeclared(StmtContext<String, BelongsToStatement, ?> ctx) {
        return new BelongsToStatementImpl(ctx);
    }

    public EffectiveStatement<String, BelongsToStatement> createEffective(StmtContext<String, BelongsToStatement, EffectiveStatement<String, BelongsToStatement>> ctx) {
        return new BelongsToEffectiveStatementImpl(ctx);
    }

    public void onPreLinkageDeclared(StmtContext.Mutable<String, BelongsToStatement, EffectiveStatement<String, BelongsToStatement>> belongsToCtx) {
        belongsToCtx.addRequiredSource(BelongsToStatementSupport.getSourceIdentifier(belongsToCtx));
    }

    public void onLinkageDeclared(final StmtContext.Mutable<String, BelongsToStatement, EffectiveStatement<String, BelongsToStatement>> belongsToCtx) {
        ModelActionBuilder belongsToAction = belongsToCtx.newInferenceAction(ModelProcessingPhase.SOURCE_LINKAGE);
        final SourceIdentifier belongsToSourceIdentifier = BelongsToStatementSupport.getSourceIdentifier(belongsToCtx);
        final ModelActionBuilder.Prerequisite belongsToPrereq = belongsToAction.requiresCtx(belongsToCtx, ModuleNamespaceForBelongsTo.class, belongsToCtx.coerceStatementArgument(), ModelProcessingPhase.SOURCE_LINKAGE);
        belongsToAction.apply(new ModelActionBuilder.InferenceAction(){

            public void apply(ModelActionBuilder.InferenceContext ctx) {
                StmtContext belongsToModuleCtx = (StmtContext)belongsToPrereq.resolve(ctx);
                belongsToCtx.addToNs(BelongsToModuleContext.class, (Object)belongsToSourceIdentifier, (Object)belongsToModuleCtx);
                belongsToCtx.addToNs(BelongsToPrefixToModuleCtx.class, StmtContextUtils.findFirstDeclaredSubstatement((StmtContext)belongsToCtx, PrefixStatement.class).coerceStatementArgument(), (Object)belongsToModuleCtx);
            }

            public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                if (failed.contains(belongsToPrereq)) {
                    throw new InferenceException(belongsToCtx.getStatementSourceReference(), "Module '%s' from belongs-to was not found", new Object[]{belongsToCtx.getStatementArgument()});
                }
            }
        });
    }

    private static SourceIdentifier getSourceIdentifier(StmtContext<String, BelongsToStatement, EffectiveStatement<String, BelongsToStatement>> belongsToCtx) {
        return RevisionSourceIdentifier.create((String)((String)belongsToCtx.coerceStatementArgument()));
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }
}

