/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.augment;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.NamespaceRevisionAware;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.WhenEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveDocumentedDataNodeContainer;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;

final class AugmentEffectiveStatementImpl
extends AbstractEffectiveDocumentedDataNodeContainer<SchemaNodeIdentifier, AugmentStatement>
implements AugmentEffectiveStatement,
AugmentationSchemaNode,
NamespaceRevisionAware {
    private final SchemaPath targetPath;
    private final URI namespace;
    private final Revision revision;
    private final @NonNull ImmutableSet<ActionDefinition> actions;
    private final @NonNull ImmutableSet<NotificationDefinition> notifications;
    private final @NonNull ImmutableList<UnknownSchemaNode> unknownNodes;
    private final RevisionAwareXPath whenCondition;
    private final AugmentationSchemaNode copyOf;

    AugmentEffectiveStatementImpl(StmtContext<SchemaNodeIdentifier, AugmentStatement, EffectiveStatement<SchemaNodeIdentifier, AugmentStatement>> ctx) {
        super(ctx);
        this.targetPath = ((SchemaNodeIdentifier)ctx.coerceStatementArgument()).asSchemaPath();
        QNameModule rootModuleQName = StmtContextUtils.getRootModuleQName(ctx);
        this.namespace = rootModuleQName.getNamespace();
        this.revision = rootModuleQName.getRevision().orElse(null);
        this.copyOf = ctx.getOriginalCtx().map(StmtContext::buildEffective).orElse(null);
        this.whenCondition = this.findFirstEffectiveSubstatementArgument(WhenEffectiveStatement.class).orElse(null);
        ImmutableSet.Builder actionsBuilder = ImmutableSet.builder();
        ImmutableSet.Builder notificationsBuilder = ImmutableSet.builder();
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        for (EffectiveStatement<?, ?> effectiveStatement : this.effectiveSubstatements()) {
            if (effectiveStatement instanceof ActionDefinition) {
                actionsBuilder.add((Object)((ActionDefinition)effectiveStatement));
                continue;
            }
            if (effectiveStatement instanceof NotificationDefinition) {
                notificationsBuilder.add((Object)((NotificationDefinition)effectiveStatement));
                continue;
            }
            if (!(effectiveStatement instanceof UnknownSchemaNode)) continue;
            listBuilder.add((Object)((UnknownSchemaNode)effectiveStatement));
        }
        this.actions = actionsBuilder.build();
        this.notifications = notificationsBuilder.build();
        this.unknownNodes = listBuilder.build();
    }

    public Optional<AugmentationSchemaNode> getOriginalDefinition() {
        return Optional.ofNullable(this.copyOf);
    }

    public SchemaPath getTargetPath() {
        return this.targetPath;
    }

    public Optional<RevisionAwareXPath> getWhenCondition() {
        return Optional.ofNullable(this.whenCondition);
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownNodes;
    }

    public URI getNamespace() {
        return this.namespace;
    }

    public Set<ActionDefinition> getActions() {
        return this.actions;
    }

    public Set<NotificationDefinition> getNotifications() {
        return this.notifications;
    }

    public Optional<Revision> getRevision() {
        return Optional.ofNullable(this.revision);
    }

    public int hashCode() {
        int prime = 17;
        int result = 1;
        result = 17 * result + Objects.hashCode(this.targetPath);
        result = 17 * result + Objects.hashCode(this.whenCondition);
        result = 17 * result + this.getChildNodes().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AugmentEffectiveStatementImpl)) {
            return false;
        }
        AugmentEffectiveStatementImpl other = (AugmentEffectiveStatementImpl)obj;
        return Objects.equals(this.targetPath, other.targetPath) && Objects.equals(this.whenCondition, other.whenCondition) && this.getChildNodes().equals(other.getChildNodes());
    }

    public String toString() {
        return AugmentEffectiveStatementImpl.class.getSimpleName() + "[targetPath=" + this.targetPath + ", when=" + this.whenCondition + "]";
    }
}

