/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.action;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ActionStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.InputStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OutputStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.namespace.ChildSchemaNodeNamespace;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.action.ActionEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.action.ActionStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.input.InputStatementRFC7950Support;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.output.OutputStatementRFC7950Support;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;

public final class ActionStatementSupport
extends AbstractQNameStatementSupport<ActionStatement, EffectiveStatement<QName, ActionStatement>> {
    private static final Set<StatementDefinition> ILLEGAL_PARENTS = ImmutableSet.of((Object)YangStmtMapping.NOTIFICATION, (Object)YangStmtMapping.RPC, (Object)YangStmtMapping.ACTION);
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.ACTION).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.GROUPING).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addOptional((StatementDefinition)YangStmtMapping.INPUT).addOptional((StatementDefinition)YangStmtMapping.OUTPUT).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addAny((StatementDefinition)YangStmtMapping.TYPEDEF).build();
    private static final ActionStatementSupport INSTANCE = new ActionStatementSupport();

    private ActionStatementSupport() {
        super((StatementDefinition)YangStmtMapping.ACTION);
    }

    public static ActionStatementSupport getInstance() {
        return INSTANCE;
    }

    public QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseIdentifier(ctx, (String)value);
    }

    public void onStatementAdded(StmtContext.Mutable<QName, ActionStatement, EffectiveStatement<QName, ActionStatement>> stmt) {
        stmt.coerceParentContext().addToNs(ChildSchemaNodeNamespace.class, stmt.coerceStatementArgument(), stmt);
    }

    public ActionStatement createDeclared(StmtContext<QName, ActionStatement, ?> ctx) {
        return new ActionStatementImpl(ctx);
    }

    public EffectiveStatement<QName, ActionStatement> createEffective(StmtContext<QName, ActionStatement, EffectiveStatement<QName, ActionStatement>> ctx) {
        SourceException.throwIf((boolean)StmtContextUtils.hasAncestorOfType(ctx, ILLEGAL_PARENTS), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Action %s is defined within a notification, rpc or another action", (Object[])new Object[]{ctx.getStatementArgument()});
        SourceException.throwIf((!StmtContextUtils.hasAncestorOfTypeWithChildOfType(ctx, (StatementDefinition)YangStmtMapping.LIST, (StatementDefinition)YangStmtMapping.KEY) ? 1 : 0) != 0, (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Action %s is defined within a list that has no key statement", (Object[])new Object[]{ctx.getStatementArgument()});
        SourceException.throwIf((boolean)StmtContextUtils.hasParentOfType(ctx, (StatementDefinition)YangStmtMapping.CASE), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Action %s is defined within a case statement", (Object[])new Object[]{ctx.getStatementArgument()});
        SourceException.throwIf((boolean)StmtContextUtils.hasParentOfType(ctx, (StatementDefinition)YangStmtMapping.MODULE), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Action %s is defined at the top level of a module", (Object[])new Object[]{ctx.getStatementArgument()});
        return new ActionEffectiveStatementImpl(ctx);
    }

    public void onFullDefinitionDeclared(StmtContext.Mutable<QName, ActionStatement, EffectiveStatement<QName, ActionStatement>> stmt) {
        super.onFullDefinitionDeclared(stmt);
        if (StmtContextUtils.findFirstDeclaredSubstatement(stmt, InputStatement.class) == null) {
            ((StatementContextBase)stmt).appendImplicitStatement((StatementSupport)InputStatementRFC7950Support.getInstance());
        }
        if (StmtContextUtils.findFirstDeclaredSubstatement(stmt, OutputStatement.class) == null) {
            ((StatementContextBase)stmt).appendImplicitStatement((StatementSupport)OutputStatementRFC7950Support.getInstance());
        }
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }
}

