/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Objects;
import javax.xml.namespace.NamespaceContext;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.parser.rfc7950.namespace.URIStringToImportPrefix;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;

final class StmtNamespaceContext
implements NamespaceContext {
    private final StmtContext<?, ?, ?> ctx;
    private final ImmutableBiMap<String, String> uriToPrefix;
    private String localNamespaceURI;

    private StmtNamespaceContext(StmtContext<?, ?, ?> ctx) {
        this(ctx, (BiMap<String, String>)ImmutableBiMap.of());
    }

    private StmtNamespaceContext(StmtContext<?, ?, ?> ctx, BiMap<String, String> uriToPrefix) {
        this.ctx = Objects.requireNonNull(ctx);
        this.uriToPrefix = ImmutableBiMap.copyOf(uriToPrefix);
    }

    public static NamespaceContext create(StmtContext<?, ?, ?> ctx) {
        return new StmtNamespaceContext(ctx);
    }

    public static NamespaceContext create(StmtContext<?, ?, ?> ctx, BiMap<String, String> uriToPrefix) {
        return new StmtNamespaceContext(ctx, uriToPrefix);
    }

    private String localNamespaceURI() {
        if (this.localNamespaceURI == null) {
            this.localNamespaceURI = (String)Verify.verifyNotNull((Object)this.ctx.getPublicDefinition().getStatementName().getNamespace().toString(), (String)"Local namespace URI not found in %s", (Object[])new Object[]{this.ctx});
        }
        return this.localNamespaceURI;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        Preconditions.checkArgument((prefix != null ? 1 : 0) != 0);
        String uri = (String)this.uriToPrefix.inverse().get((Object)prefix);
        if (uri != null) {
            return uri;
        }
        if (prefix.isEmpty()) {
            return this.localNamespaceURI();
        }
        QNameModule module = StmtContextUtils.getModuleQNameByPrefix(this.ctx, (String)prefix);
        return module == null ? null : module.getNamespace().toString();
    }

    @Override
    public String getPrefix(String namespaceURI) {
        Preconditions.checkArgument((namespaceURI != null ? 1 : 0) != 0);
        String prefix = (String)this.uriToPrefix.get((Object)namespaceURI);
        if (prefix != null) {
            return prefix;
        }
        if (this.localNamespaceURI().equals(namespaceURI)) {
            return "";
        }
        return (String)this.ctx.getFromNamespace(URIStringToImportPrefix.class, (Object)namespaceURI);
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        return Iterators.unmodifiableIterator((Iterator)Iterators.concat(this.ctx.getAllFromNamespace(URIStringToImportPrefix.class).values().iterator(), (Iterator)this.uriToPrefix.values().iterator()));
    }
}

