/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.base.Verify;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStatementBase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

public abstract class DeclaredEffectiveStatementBase<A, D extends DeclaredStatement<A>>
extends EffectiveStatementBase<A, D> {
    private final @NonNull StatementSource statementSource;
    private final A argument;
    private final @NonNull D declaredInstance;

    protected DeclaredEffectiveStatementBase(StmtContext<A, D, ?> ctx) {
        super(ctx);
        this.argument = ctx.getStatementArgument();
        this.statementSource = ctx.getStatementSource();
        StmtContext<A, D, ?> lookupCtx = ctx.getOriginalCtx().orElse(ctx);
        this.declaredInstance = (DeclaredStatement)Verify.verifyNotNull((Object)lookupCtx.buildDeclared(), (String)"Statement %s failed to build declared statement", (Object[])new Object[]{lookupCtx});
    }

    public final StatementDefinition statementDefinition() {
        return this.declaredInstance.statementDefinition();
    }

    public A argument() {
        return this.argument;
    }

    public final StatementSource getStatementSource() {
        return this.statementSource;
    }

    public final D getDeclared() {
        return this.declaredInstance;
    }
}

