/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.annotations.Beta;
import com.google.common.base.Splitter;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.RegEx;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.UnresolvedNumber;
import org.opendaylight.yangtools.yang.model.util.RevisionAwareXPathImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.StmtNamespaceContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class ArgumentUtils {
    public static final Splitter PIPE_SPLITTER = Splitter.on((char)'|').trimResults();
    public static final Splitter TWO_DOTS_SPLITTER = Splitter.on((String)"..").trimResults();
    private static final Logger LOG = LoggerFactory.getLogger(ArgumentUtils.class);
    @RegEx
    private static final String YANG_XPATH_FUNCTIONS_STRING = "(re-match|deref|derived-from(-or-self)?|enum-value|bit-is-set)([ \t\r\n]*)(\\()";
    private static final Pattern YANG_XPATH_FUNCTIONS_PATTERN = Pattern.compile("(re-match|deref|derived-from(-or-self)?|enum-value|bit-is-set)([ \t\r\n]*)(\\()");
    @RegEx
    private static final String PATH_ABS_STR = "/[^/].*";
    private static final Pattern PATH_ABS = Pattern.compile("/[^/].*");
    private static final Splitter SLASH_SPLITTER = Splitter.on((char)'/').omitEmptyStrings().trimResults();
    private static final ThreadLocal<XPathFactory> XPATH_FACTORY = new ThreadLocal<XPathFactory>(){

        @Override
        protected XPathFactory initialValue() {
            return XPathFactory.newInstance();
        }
    };
    private static final BigDecimal YANG_MIN_NUM = BigDecimal.valueOf(-1.7976931348623157E308);
    private static final BigDecimal YANG_MAX_NUM = BigDecimal.valueOf(Double.MAX_VALUE);

    private ArgumentUtils() {
        throw new UnsupportedOperationException();
    }

    public static int compareNumbers(Number n1, Number n2) {
        BigDecimal num1 = ArgumentUtils.yangConstraintToBigDecimal(n1);
        BigDecimal num2 = ArgumentUtils.yangConstraintToBigDecimal(n2);
        return new BigDecimal(num1.toString()).compareTo(new BigDecimal(num2.toString()));
    }

    public static String internBoolean(String input) {
        if ("true".equals(input)) {
            return "true";
        }
        if ("false".equals(input)) {
            return "false";
        }
        return input;
    }

    public static @NonNull Boolean parseBoolean(StmtContext<?, ?, ?> ctx, String input) {
        if ("true".equals(input)) {
            return Boolean.TRUE;
        }
        if ("false".equals(input)) {
            return Boolean.FALSE;
        }
        throw new SourceException(ctx.getStatementSourceReference(), "Invalid '%s' statement %s '%s', it can be either 'true' or 'false'", new Object[]{ctx.getPublicDefinition().getStatementName(), ctx.getPublicDefinition().getArgumentName(), input});
    }

    public static RevisionAwareXPath parseXPath(StmtContext<?, ?, ?> ctx, String path) {
        XPath xPath = XPATH_FACTORY.get().newXPath();
        xPath.setNamespaceContext(StmtNamespaceContext.create(ctx, (BiMap<String, String>)ImmutableBiMap.of((Object)"urn:ietf:params:xml:ns:yang:1", (Object)"yang")));
        String trimmed = ArgumentUtils.trimSingleLastSlashFromXPath(path);
        try {
            String prefixedXPath = ArgumentUtils.addPrefixToYangXPathFunctions(trimmed, ctx);
            xPath.compile(prefixedXPath);
        }
        catch (XPathExpressionException e) {
            LOG.warn("Argument \"{}\" is not valid XPath string at \"{}\"", new Object[]{path, ctx.getStatementSourceReference(), e});
        }
        return new RevisionAwareXPathImpl(path, PATH_ABS.matcher(path).matches());
    }

    public static SchemaNodeIdentifier nodeIdentifierFromPath(StmtContext<?, ?, ?> ctx, String path) {
        ArrayList<QName> qNames = new ArrayList<QName>();
        for (String nodeName : SLASH_SPLITTER.split((CharSequence)ArgumentUtils.trimSingleLastSlashFromXPath(path))) {
            try {
                qNames.add(StmtContextUtils.parseNodeIdentifier(ctx, (String)nodeName));
            }
            catch (RuntimeException e) {
                throw new SourceException(ctx.getStatementSourceReference(), (Throwable)e, "Failed to parse node '%s' in path '%s'", new Object[]{nodeName, path});
            }
        }
        return SchemaNodeIdentifier.create(qNames, (boolean)PATH_ABS.matcher(path).matches());
    }

    public static void detachFromCurrentThread() {
        XPATH_FACTORY.remove();
    }

    private static String addPrefixToYangXPathFunctions(String path, StmtContext<?, ?, ?> ctx) {
        if (ctx.getRootVersion() == YangVersion.VERSION_1_1) {
            StringBuffer result = new StringBuffer();
            String prefix = "yang:";
            Matcher matcher = YANG_XPATH_FUNCTIONS_PATTERN.matcher(path);
            while (matcher.find()) {
                matcher.appendReplacement(result, "yang:" + matcher.group());
            }
            matcher.appendTail(result);
            return result.toString();
        }
        return path;
    }

    private static String trimSingleLastSlashFromXPath(String path) {
        return path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
    }

    private static BigDecimal yangConstraintToBigDecimal(Number number) {
        if (UnresolvedNumber.max().equals(number)) {
            return YANG_MAX_NUM;
        }
        if (UnresolvedNumber.min().equals(number)) {
            return YANG_MIN_NUM;
        }
        return new BigDecimal(number.toString());
    }
}

