/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.OperationDefinition;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.InputEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OutputEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveSchemaNode;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStmtUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

@Beta
public abstract class AbstractEffectiveOperationDefinition<D extends DeclaredStatement<QName>>
extends AbstractEffectiveSchemaNode<D>
implements OperationDefinition {
    private final ImmutableSet<TypeDefinition<?>> typeDefinitions;
    private final ImmutableSet<GroupingDefinition> groupings;
    private final ContainerSchemaNode input = AbstractEffectiveOperationDefinition.findAsContainer(this, InputEffectiveStatement.class);
    private final ContainerSchemaNode output = AbstractEffectiveOperationDefinition.findAsContainer(this, OutputEffectiveStatement.class);

    protected AbstractEffectiveOperationDefinition(StmtContext<QName, D, ?> ctx) {
        super(ctx);
        HashSet<GroupingDefinition> groupingsInit = new HashSet<GroupingDefinition>();
        LinkedHashSet<TypeDefinition> mutableTypeDefinitions = new LinkedHashSet<TypeDefinition>();
        for (EffectiveStatement<?, ?> effectiveStatement : this.effectiveSubstatements()) {
            if (effectiveStatement instanceof GroupingDefinition) {
                GroupingDefinition groupingDefinition = (GroupingDefinition)effectiveStatement;
                groupingsInit.add(groupingDefinition);
            }
            if (!(effectiveStatement instanceof TypedefEffectiveStatement)) continue;
            TypedefEffectiveStatement typeDef = (TypedefEffectiveStatement)effectiveStatement;
            TypeDefinition type = typeDef.getTypeDefinition();
            if (!mutableTypeDefinitions.contains(type)) {
                mutableTypeDefinitions.add(type);
                continue;
            }
            throw EffectiveStmtUtils.createNameCollisionSourceException(ctx, effectiveStatement);
        }
        this.groupings = ImmutableSet.copyOf(groupingsInit);
        this.typeDefinitions = ImmutableSet.copyOf(mutableTypeDefinitions);
    }

    private static ContainerSchemaNode findAsContainer(EffectiveStatement<?, ?> parent, Class<? extends EffectiveStatement<QName, ?>> statementType) {
        EffectiveStatement statement = (EffectiveStatement)parent.findFirstEffectiveSubstatement(statementType).get();
        Verify.verify((boolean)(statement instanceof ContainerSchemaNode), (String)"Child statement %s is not a ContainerSchemaNode", (Object[])new Object[0]);
        return (ContainerSchemaNode)statement;
    }

    public final ContainerSchemaNode getInput() {
        return this.input;
    }

    public final ContainerSchemaNode getOutput() {
        return this.output;
    }

    public final Set<TypeDefinition<?>> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    public final Set<GroupingDefinition> getGroupings() {
        return this.groupings;
    }

    public final int hashCode() {
        return Objects.hash(this.getQName(), this.getPath());
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractEffectiveOperationDefinition other = (AbstractEffectiveOperationDefinition)obj;
        return Objects.equals(this.getQName(), other.getQName()) && Objects.equals(this.getPath(), other.getPath());
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("qname", (Object)this.getQName()).add("path", (Object)this.getPath()).add("input", (Object)this.input).add("output", (Object)this.output).toString();
    }
}

