/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.SemVer;
import org.opendaylight.yangtools.openconfig.model.api.OpenConfigVersionEffectiveStatement;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Deviation;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.FeatureDefinition;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.BelongsToEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ContactEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OrganizationEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.YangVersionEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractSchemaEffectiveDocumentedNode;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStmtUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.MutableStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.IncludedSubmoduleNameToModuleCtx;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

@Beta
public abstract class AbstractEffectiveModule<D extends DeclaredStatement<String>>
extends AbstractSchemaEffectiveDocumentedNode<String, D>
implements Module,
MutableStatement {
    private final String name = (String)this.argument();
    private final String prefix;
    private final YangVersion yangVersion;
    private final String organization;
    private final String contact;
    private final ImmutableSet<ModuleImport> imports;
    private final ImmutableSet<FeatureDefinition> features;
    private final @NonNull ImmutableSet<NotificationDefinition> notifications;
    private final ImmutableSet<AugmentationSchemaNode> augmentations;
    private final ImmutableSet<RpcDefinition> rpcs;
    private final ImmutableSet<Deviation> deviations;
    private final ImmutableList<ExtensionDefinition> extensionNodes;
    private final ImmutableSet<IdentitySchemaNode> identities;
    private final @NonNull ImmutableList<UnknownSchemaNode> unknownNodes;
    private final ImmutableMap<QName, DataSchemaNode> childNodes;
    private final ImmutableSet<GroupingDefinition> groupings;
    private final ImmutableSet<UsesNode> uses;
    private final ImmutableSet<TypeDefinition<?>> typeDefinitions;
    private final ImmutableSet<DataSchemaNode> publicChildNodes;
    private final SemVer semanticVersion;
    private Set<StmtContext<?, SubmoduleStatement, EffectiveStatement<String, SubmoduleStatement>>> submoduleContextsToBuild;
    private ImmutableSet<Module> submodules;
    private boolean sealed;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected AbstractEffectiveModule(StmtContext<String, D, ? extends EffectiveStatement<String, ?>> ctx) {
        super(ctx);
        ImmutableList substatementsOfSubmodules;
        AbstractEffectiveModule parentOfPrefix;
        if (ctx.getPublicDefinition() == YangStmtMapping.SUBMODULE) {
            Optional optParent = this.findFirstEffectiveSubstatement(BelongsToEffectiveStatement.class);
            SourceException.throwIf((!optParent.isPresent() ? 1 : 0) != 0, (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Unable to find belongs-to statement in submodule %s.", (Object[])new Object[]{ctx.getStatementArgument()});
            parentOfPrefix = (EffectiveStatement)optParent.get();
        } else {
            parentOfPrefix = this;
        }
        @NonNull Optional prefixStmt = parentOfPrefix.findFirstEffectiveSubstatement(PrefixEffectiveStatement.class);
        SourceException.throwIf((!prefixStmt.isPresent() ? 1 : 0) != 0, (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Unable to resolve prefix for module or submodule %s.", (Object[])new Object[]{ctx.getStatementArgument()});
        this.prefix = (String)((PrefixEffectiveStatement)prefixStmt.get()).argument();
        this.yangVersion = this.findFirstEffectiveSubstatementArgument(YangVersionEffectiveStatement.class).orElse(YangVersion.VERSION_1);
        this.semanticVersion = this.findFirstEffectiveSubstatementArgument(OpenConfigVersionEffectiveStatement.class).orElse(null);
        this.organization = this.findFirstEffectiveSubstatementArgument(OrganizationEffectiveStatement.class).orElse(null);
        this.contact = this.findFirstEffectiveSubstatementArgument(ContactEffectiveStatement.class).orElse(null);
        Map includedSubmodulesMap = ctx.getAllFromCurrentStmtCtxNamespace(IncludedSubmoduleNameToModuleCtx.class);
        if (includedSubmodulesMap == null || includedSubmodulesMap.isEmpty()) {
            this.submodules = ImmutableSet.of();
            this.submoduleContextsToBuild = ImmutableSet.of();
            substatementsOfSubmodules = ImmutableList.of();
        } else if (YangStmtMapping.MODULE.equals((Object)ctx.getPublicDefinition())) {
            HashSet<Module> submodulesInit = new HashSet<Module>();
            ArrayList substatementsOfSubmodulesInit = new ArrayList();
            for (StmtContext submoduleCtx : includedSubmodulesMap.values()) {
                EffectiveStatement submodule = submoduleCtx.buildEffective();
                Verify.verify((boolean)(submodule instanceof SubmoduleEffectiveStatement));
                Verify.verify((boolean)(submodule instanceof Module), (String)"Submodule statement %s is not a Module", (Object)submodule);
                submodulesInit.add((Module)submodule);
                substatementsOfSubmodulesInit.addAll(submodule.effectiveSubstatements().stream().filter(sub -> sub instanceof SchemaNode || sub instanceof DataNodeContainer).collect(Collectors.toList()));
            }
            this.submodules = ImmutableSet.copyOf(submodulesInit);
            this.submoduleContextsToBuild = ImmutableSet.of();
            substatementsOfSubmodules = ImmutableList.copyOf((Collection)substatementsOfSubmodulesInit);
        } else {
            HashSet<StmtContext> submoduleContextsInit = new HashSet<StmtContext>();
            for (StmtContext submoduleCtx : includedSubmodulesMap.values()) {
                submoduleContextsInit.add(submoduleCtx);
            }
            this.submoduleContextsToBuild = ImmutableSet.copyOf(submoduleContextsInit);
            substatementsOfSubmodules = ImmutableList.of();
        }
        if (!this.submoduleContextsToBuild.isEmpty()) {
            ((StmtContext.Mutable)ctx).addMutableStmtToSeal((MutableStatement)this);
            this.sealed = false;
        } else {
            this.sealed = true;
        }
        ArrayList effectiveSubstatements = new ArrayList();
        effectiveSubstatements.addAll(this.effectiveSubstatements());
        effectiveSubstatements.addAll((Collection<EffectiveStatement<?, ?>>)substatementsOfSubmodules);
        ArrayList<UnknownSchemaNode> unknownNodesInit = new ArrayList<UnknownSchemaNode>();
        LinkedHashSet<AugmentationSchemaNode> augmentationsInit = new LinkedHashSet<AugmentationSchemaNode>();
        HashSet<ModuleImport> importsInit = new HashSet<ModuleImport>();
        HashSet<NotificationDefinition> notificationsInit = new HashSet<NotificationDefinition>();
        HashSet<RpcDefinition> rpcsInit = new HashSet<RpcDefinition>();
        HashSet<Deviation> deviationsInit = new HashSet<Deviation>();
        HashSet<IdentitySchemaNode> identitiesInit = new HashSet<IdentitySchemaNode>();
        HashSet<FeatureDefinition> featuresInit = new HashSet<FeatureDefinition>();
        ArrayList<ExtensionDefinition> extensionNodesInit = new ArrayList<ExtensionDefinition>();
        LinkedHashMap<QName, DataSchemaNode> mutableChildNodes = new LinkedHashMap<QName, DataSchemaNode>();
        HashSet<GroupingDefinition> mutableGroupings = new HashSet<GroupingDefinition>();
        HashSet<UsesNode> mutableUses = new HashSet<UsesNode>();
        LinkedHashSet<TypeDefinition> mutableTypeDefinitions = new LinkedHashSet<TypeDefinition>();
        LinkedHashSet<DataSchemaNode> mutablePublicChildNodes = new LinkedHashSet<DataSchemaNode>();
        for (EffectiveStatement effectiveStatement : effectiveSubstatements) {
            if (effectiveStatement instanceof UnknownSchemaNode) {
                unknownNodesInit.add((UnknownSchemaNode)effectiveStatement);
            }
            if (effectiveStatement instanceof AugmentationSchemaNode) {
                augmentationsInit.add((AugmentationSchemaNode)effectiveStatement);
            }
            if (effectiveStatement instanceof ModuleImport) {
                importsInit.add((ModuleImport)effectiveStatement);
            }
            if (effectiveStatement instanceof NotificationDefinition) {
                notificationsInit.add((NotificationDefinition)effectiveStatement);
            }
            if (effectiveStatement instanceof RpcDefinition) {
                rpcsInit.add((RpcDefinition)effectiveStatement);
            }
            if (effectiveStatement instanceof Deviation) {
                deviationsInit.add((Deviation)effectiveStatement);
            }
            if (effectiveStatement instanceof IdentitySchemaNode) {
                identitiesInit.add((IdentitySchemaNode)effectiveStatement);
            }
            if (effectiveStatement instanceof FeatureDefinition) {
                featuresInit.add((FeatureDefinition)effectiveStatement);
            }
            if (effectiveStatement instanceof ExtensionDefinition) {
                extensionNodesInit.add((ExtensionDefinition)effectiveStatement);
            }
            if (effectiveStatement instanceof DataSchemaNode) {
                DataSchemaNode dataSchemaNode = (DataSchemaNode)effectiveStatement;
                if (!mutableChildNodes.containsKey(dataSchemaNode.getQName())) {
                    mutableChildNodes.put(dataSchemaNode.getQName(), dataSchemaNode);
                    mutablePublicChildNodes.add(dataSchemaNode);
                } else {
                    throw EffectiveStmtUtils.createNameCollisionSourceException(ctx, effectiveStatement);
                }
            }
            if (effectiveStatement instanceof UsesNode) {
                UsesNode usesNode = (UsesNode)effectiveStatement;
                if (!mutableUses.contains(usesNode)) {
                    mutableUses.add(usesNode);
                } else {
                    throw EffectiveStmtUtils.createNameCollisionSourceException(ctx, effectiveStatement);
                }
            }
            if (effectiveStatement instanceof TypedefEffectiveStatement) {
                TypedefEffectiveStatement typeDef = (TypedefEffectiveStatement)effectiveStatement;
                TypeDefinition type = typeDef.getTypeDefinition();
                if (!mutableTypeDefinitions.contains(type)) {
                    mutableTypeDefinitions.add(type);
                } else {
                    throw EffectiveStmtUtils.createNameCollisionSourceException(ctx, effectiveStatement);
                }
            }
            if (!(effectiveStatement instanceof GroupingDefinition)) continue;
            GroupingDefinition grp = (GroupingDefinition)effectiveStatement;
            if (!mutableGroupings.contains(grp)) {
                mutableGroupings.add(grp);
                continue;
            }
            throw EffectiveStmtUtils.createNameCollisionSourceException(ctx, effectiveStatement);
        }
        this.unknownNodes = ImmutableList.copyOf(unknownNodesInit);
        this.augmentations = ImmutableSet.copyOf(augmentationsInit);
        this.imports = ImmutableSet.copyOf(importsInit);
        this.notifications = ImmutableSet.copyOf(notificationsInit);
        this.rpcs = ImmutableSet.copyOf(rpcsInit);
        this.deviations = ImmutableSet.copyOf(deviationsInit);
        this.identities = ImmutableSet.copyOf(identitiesInit);
        this.features = ImmutableSet.copyOf(featuresInit);
        this.extensionNodes = ImmutableList.copyOf(extensionNodesInit);
        this.childNodes = ImmutableMap.copyOf(mutableChildNodes);
        this.groupings = ImmutableSet.copyOf(mutableGroupings);
        this.publicChildNodes = ImmutableSet.copyOf(mutablePublicChildNodes);
        this.typeDefinitions = ImmutableSet.copyOf(mutableTypeDefinitions);
        this.uses = ImmutableSet.copyOf(mutableUses);
    }

    public URI getNamespace() {
        return this.getQNameModule().getNamespace();
    }

    public String getName() {
        return this.name;
    }

    public Optional<Revision> getRevision() {
        return this.getQNameModule().getRevision();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public YangVersion getYangVersion() {
        return this.yangVersion;
    }

    public Optional<String> getOrganization() {
        return Optional.ofNullable(this.organization);
    }

    public Optional<String> getContact() {
        return Optional.ofNullable(this.contact);
    }

    public Set<ModuleImport> getImports() {
        return this.imports;
    }

    public Set<Module> getSubmodules() {
        Preconditions.checkState((boolean)this.sealed, (String)"Attempt to get base submodules from unsealed submodule effective statement %s", (Object)this.getQNameModule());
        return this.submodules;
    }

    public Set<FeatureDefinition> getFeatures() {
        return this.features;
    }

    public Set<NotificationDefinition> getNotifications() {
        return this.notifications;
    }

    public Set<AugmentationSchemaNode> getAugmentations() {
        return this.augmentations;
    }

    public Set<RpcDefinition> getRpcs() {
        return this.rpcs;
    }

    public Set<Deviation> getDeviations() {
        return this.deviations;
    }

    public List<ExtensionDefinition> getExtensionSchemaNodes() {
        return this.extensionNodes;
    }

    public Set<IdentitySchemaNode> getIdentities() {
        return this.identities;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownNodes;
    }

    public final Set<TypeDefinition<?>> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    public final Set<DataSchemaNode> getChildNodes() {
        return this.publicChildNodes;
    }

    public final Set<GroupingDefinition> getGroupings() {
        return this.groupings;
    }

    public final Optional<DataSchemaNode> findDataChildByName(QName name) {
        return Optional.ofNullable(this.childNodes.get((Object)Objects.requireNonNull(name)));
    }

    public Set<UsesNode> getUses() {
        return this.uses;
    }

    public Optional<SemVer> getSemanticVersion() {
        return Optional.ofNullable(this.semanticVersion);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("namespace", (Object)this.getNamespace()).add("revision", this.getRevision().orElse(null)).add("prefix", (Object)this.prefix).add("yangVersion", (Object)this.yangVersion).toString();
    }

    public void seal() {
        if (!this.sealed) {
            this.submodules = ImmutableSet.copyOf((Iterable)Iterables.transform(this.submoduleContextsToBuild, ctx -> (Module)ctx.buildEffective()));
            this.submoduleContextsToBuild = ImmutableSet.of();
            this.sealed = true;
        }
    }
}

