/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.repo;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.Futures;
import java.io.IOException;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.yangtools.util.xml.UntrustedXML;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YinDomSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.api.YinTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;
import org.opendaylight.yangtools.yang.model.repo.util.SchemaSourceTransformer;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.StatementSourceReferenceHandler;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Beta
public final class YinTextToDomTransformer
extends SchemaSourceTransformer<YinTextSchemaSource, YinDomSchemaSource> {
    private YinTextToDomTransformer(SchemaRepository provider, SchemaSourceRegistry consumer) {
        super(provider, YinTextSchemaSource.class, consumer, YinDomSchemaSource.class, input -> Futures.immediateFuture((Object)YinTextToDomTransformer.transformSource(input)));
    }

    public static YinTextToDomTransformer create(SchemaRepository provider, SchemaSourceRegistry consumer) {
        return new YinTextToDomTransformer(provider, consumer);
    }

    public static YinDomSchemaSource transformSource(YinTextSchemaSource source) throws SAXException, IOException {
        Document doc = UntrustedXML.newDocumentBuilder().newDocument();
        SAXParser parser = UntrustedXML.newSAXParser();
        StatementSourceReferenceHandler handler = new StatementSourceReferenceHandler(doc, null);
        parser.parse(source.openStream(), (DefaultHandler)handler);
        return YinDomSchemaSource.create((SourceIdentifier)source.getIdentifier(), (DOMSource)new DOMSource(doc));
    }
}

