/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.repo;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Objects;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.opendaylight.yangtools.antlrv4.code.gen.YangStatementLexer;
import org.opendaylight.yangtools.antlrv4.code.gen.YangStatementParser;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.ASTSchemaSource;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.StatementContextVisitor;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YangErrorListener;
import org.opendaylight.yangtools.yang.parser.spi.source.PrefixToModule;
import org.opendaylight.yangtools.yang.parser.spi.source.QNameToStatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementStreamSource;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementWriter;

@Beta
public final class YangStatementStreamSource
implements StatementStreamSource {
    private static final ParseTreeListener MAKE_IMMUTABLE_LISTENER = new ParseTreeListener(){

        public void enterEveryRule(ParserRuleContext ctx) {
        }

        public void exitEveryRule(ParserRuleContext ctx) {
            ctx.children = ctx.children == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)ctx.children);
        }

        public void visitTerminal(TerminalNode node) {
        }

        public void visitErrorNode(ErrorNode node) {
        }
    };
    private final SourceIdentifier identifier;
    private final YangStatementParser.StatementContext context;
    private final String sourceName;

    private YangStatementStreamSource(SourceIdentifier identifier, YangStatementParser.StatementContext context, String sourceName) {
        this.identifier = Objects.requireNonNull(identifier);
        this.context = Objects.requireNonNull(context);
        this.sourceName = sourceName;
    }

    public static YangStatementStreamSource create(YangTextSchemaSource source) throws IOException, YangSyntaxErrorException {
        YangStatementParser.StatementContext context;
        try (InputStream stream = source.openStream();){
            context = YangStatementStreamSource.parseYangSource(source.getIdentifier(), stream);
        }
        return new YangStatementStreamSource(source.getIdentifier(), context, source.getSymbolicName().orElse(null));
    }

    public static YangStatementStreamSource create(ASTSchemaSource source) {
        ParserRuleContext ast = source.getAST();
        Preconditions.checkArgument((boolean)(ast instanceof YangStatementParser.StatementContext), (String)"Unsupported context class %s for source %s", ast.getClass(), (Object)source.getIdentifier());
        return YangStatementStreamSource.create(source.getIdentifier(), (YangStatementParser.StatementContext)ast, source.getSymbolicName().orElse(null));
    }

    public static YangStatementStreamSource create(SourceIdentifier identifier, YangStatementParser.StatementContext context, String symbolicName) {
        return new YangStatementStreamSource(identifier, context, symbolicName);
    }

    public void writePreLinkage(StatementWriter writer, QNameToStatementDefinition stmtDef) {
        new StatementContextVisitor(this.sourceName, writer, stmtDef, null, YangVersion.VERSION_1).visit(this.context);
    }

    public void writeLinkage(StatementWriter writer, QNameToStatementDefinition stmtDef, PrefixToModule preLinkagePrefixes) {
        this.writeLinkage(writer, stmtDef, preLinkagePrefixes, YangVersion.VERSION_1);
    }

    public void writeLinkage(StatementWriter writer, final QNameToStatementDefinition stmtDef, PrefixToModule preLinkagePrefixes, YangVersion yangVersion) {
        new StatementContextVisitor(this.sourceName, writer, stmtDef, preLinkagePrefixes, yangVersion){

            @Override
            StatementDefinition resolveStatement(QNameModule module, String localName) {
                return stmtDef.getByNamespaceAndLocalName(module.getNamespace(), localName);
            }
        }.visit(this.context);
    }

    public void writeLinkageAndStatementDefinitions(StatementWriter writer, QNameToStatementDefinition stmtDef, PrefixToModule prefixes) {
        this.writeLinkageAndStatementDefinitions(writer, stmtDef, prefixes, YangVersion.VERSION_1);
    }

    public void writeLinkageAndStatementDefinitions(StatementWriter writer, QNameToStatementDefinition stmtDef, PrefixToModule prefixes, YangVersion yangVersion) {
        new StatementContextVisitor(this.sourceName, writer, stmtDef, prefixes, yangVersion).visit(this.context);
    }

    public void writeFull(StatementWriter writer, QNameToStatementDefinition stmtDef, PrefixToModule prefixes) {
        this.writeFull(writer, stmtDef, prefixes, YangVersion.VERSION_1);
    }

    public void writeFull(StatementWriter writer, QNameToStatementDefinition stmtDef, PrefixToModule prefixes, YangVersion yangVersion) {
        new StatementContextVisitor(this.sourceName, writer, stmtDef, prefixes, yangVersion){

            @Override
            QName getValidStatementDefinition(String keywordText, StatementSourceReference ref) {
                return (QName)SourceException.throwIfNull((Object)super.getValidStatementDefinition(keywordText, ref), (StatementSourceReference)ref, (String)"%s is not a YANG statement or use of extension.", (Object[])new Object[]{keywordText});
            }
        }.visit(this.context);
    }

    public SourceIdentifier getIdentifier() {
        return this.identifier;
    }

    public ParserRuleContext getYangAST() {
        return this.context;
    }

    private static YangStatementParser.StatementContext parseYangSource(SourceIdentifier source, InputStream stream) throws IOException, YangSyntaxErrorException {
        YangStatementLexer lexer = new YangStatementLexer(CharStreams.fromStream((InputStream)stream));
        YangStatementParser parser = new YangStatementParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        lexer.removeErrorListeners();
        parser.removeErrorListeners();
        YangErrorListener errorListener = new YangErrorListener(source);
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        YangStatementParser.StatementContext result = parser.statement();
        errorListener.validate();
        ParseTreeWalker.DEFAULT.walk(MAKE_IMMUTABLE_LISTENER, (ParseTree)result);
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("identifier", (Object)this.getIdentifier()).toString();
    }
}

