/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.repo;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.Futures;
import java.io.IOException;
import org.antlr.v4.runtime.ParserRuleContext;
import org.opendaylight.yangtools.yang.model.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;
import org.opendaylight.yangtools.yang.model.repo.util.SchemaSourceTransformer;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.ASTSchemaSource;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YangStatementStreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class TextToASTTransformer
extends SchemaSourceTransformer<YangTextSchemaSource, ASTSchemaSource> {
    private static final Logger LOG = LoggerFactory.getLogger(TextToASTTransformer.class);

    private TextToASTTransformer(SchemaRepository provider, SchemaSourceRegistry consumer) {
        super(provider, YangTextSchemaSource.class, consumer, ASTSchemaSource.class, input -> Futures.immediateFuture((Object)TextToASTTransformer.transformText(input)));
    }

    public static TextToASTTransformer create(SchemaRepository provider, SchemaSourceRegistry consumer) {
        return new TextToASTTransformer(provider, consumer);
    }

    public static ASTSchemaSource transformText(YangTextSchemaSource text) throws SchemaSourceException, IOException, YangSyntaxErrorException {
        YangStatementStreamSource src = YangStatementStreamSource.create(text);
        ParserRuleContext ctx = src.getYangAST();
        LOG.debug("Model {} parsed successfully", (Object)text);
        return ASTSchemaSource.create(text.getIdentifier(), text.getSymbolicName().orElse(null), ctx);
    }
}

