/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.repo;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.opendaylight.yangtools.antlrv4.code.gen.YangStatementParser;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

final class ArgumentContextUtils {
    private static final CharMatcher WHITESPACE_MATCHER = CharMatcher.whitespace();
    private static final CharMatcher ANYQUOTE_MATCHER = CharMatcher.anyOf((CharSequence)"'\"");
    private static final Pattern ESCAPED_DQUOT = Pattern.compile("\\\"", 16);
    private static final Pattern ESCAPED_BACKSLASH = Pattern.compile("\\\\", 16);
    private static final Pattern ESCAPED_LF = Pattern.compile("\\n", 16);
    private static final Pattern ESCAPED_TAB = Pattern.compile("\\t", 16);

    private ArgumentContextUtils() {
        throw new UnsupportedOperationException();
    }

    static String stringFromStringContext(YangStatementParser.ArgumentContext context, YangVersion yangVersion, StatementSourceReference ref) {
        StringBuilder sb = new StringBuilder();
        List<TerminalNode> strings = context.STRING();
        if (strings.isEmpty()) {
            strings = Collections.singletonList(context.IDENTIFIER());
        }
        for (TerminalNode stringNode : strings) {
            String str = stringNode.getText();
            char firstChar = str.charAt(0);
            char lastChar = str.charAt(str.length() - 1);
            if (firstChar == '\"' && lastChar == '\"') {
                String innerStr = str.substring(1, str.length() - 1);
                ArgumentContextUtils.checkDoubleQuotedString(innerStr, yangVersion, ref);
                sb.append(ESCAPED_TAB.matcher(ESCAPED_LF.matcher(ESCAPED_BACKSLASH.matcher(ESCAPED_DQUOT.matcher(ArgumentContextUtils.trimWhitespace(innerStr, stringNode.getSymbol().getCharPositionInLine())).replaceAll("\\\"")).replaceAll("\\\\")).replaceAll("\\\n")).replaceAll("\\\t"));
                continue;
            }
            if (firstChar == '\'' && lastChar == '\'') {
                sb.append(str, 1, str.length() - 1);
                continue;
            }
            ArgumentContextUtils.checkUnquotedString(str, yangVersion, ref);
            sb.append(str);
        }
        return sb.toString();
    }

    private static void checkUnquotedString(String str, YangVersion yangVersion, StatementSourceReference ref) {
        if (yangVersion == YangVersion.VERSION_1_1) {
            SourceException.throwIf((boolean)ANYQUOTE_MATCHER.matchesAnyOf((CharSequence)str), (StatementSourceReference)ref, (String)"YANG 1.1: unquoted string (%s) contains illegal characters", (Object[])new Object[]{str});
        }
    }

    private static void checkDoubleQuotedString(String str, YangVersion yangVersion, StatementSourceReference ref) {
        if (yangVersion == YangVersion.VERSION_1_1) {
            block3: for (int i = 0; i < str.length() - 1; ++i) {
                if (str.charAt(i) != '\\') continue;
                switch (str.charAt(i + 1)) {
                    case '\"': 
                    case '\\': 
                    case 'n': 
                    case 't': {
                        ++i;
                        continue block3;
                    }
                    default: {
                        throw new SourceException(ref, "YANG 1.1: illegal double quoted string (%s). In double quoted string the backslash must be followed by one of the following character [n,t,\",\\], but was '%s'.", new Object[]{str, Character.valueOf(str.charAt(i + 1))});
                    }
                }
            }
        }
    }

    @VisibleForTesting
    static String trimWhitespace(String str, int dquot) {
        int brk = str.indexOf(10);
        if (brk == -1) {
            return str;
        }
        int length = str.length();
        StringBuilder sb = new StringBuilder(length);
        sb.append(str, 0, ArgumentContextUtils.trimTrailing(str, 0, brk)).append('\n');
        int start = brk + 1;
        brk = str.indexOf(10, start);
        while (brk != -1) {
            ArgumentContextUtils.trimLeadingAndAppend(sb, dquot, str, start, ArgumentContextUtils.trimTrailing(str, start, brk)).append('\n');
            start = brk + 1;
            brk = str.indexOf(10, start);
        }
        return ArgumentContextUtils.trimLeadingAndAppend(sb, dquot, str, start, length).toString();
    }

    private static StringBuilder trimLeadingAndAppend(StringBuilder sb, int dquot, String str, int start, int end) {
        int offset = start;
        int pos = 0;
        while (pos <= dquot) {
            if (offset == end) {
                return sb;
            }
            char ch = str.charAt(offset);
            if (ch == '\t') {
                pos += 8;
            } else {
                if (!WHITESPACE_MATCHER.matches(ch)) break;
                ++pos;
            }
            ++offset;
        }
        while (pos - 1 > dquot) {
            sb.append(' ');
            --pos;
        }
        return sb.append(str, offset, end);
    }

    private static int trimTrailing(String str, int start, int end) {
        int prev;
        int ret = end;
        while (ret > start && WHITESPACE_MATCHER.matches(str.charAt(prev = ret - 1))) {
            ret = prev;
        }
        return ret;
    }
}

