/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.api;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.opendaylight.aaa.api.IDMStoreException;
import org.opendaylight.aaa.api.IIDMStore;
import org.opendaylight.aaa.api.IdMService;
import org.opendaylight.aaa.api.model.Domain;
import org.opendaylight.aaa.api.model.Grant;
import org.opendaylight.aaa.api.model.Grants;
import org.opendaylight.aaa.api.model.Role;
import org.opendaylight.aaa.api.model.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdMServiceImpl
implements IdMService {
    private static final Logger LOG = LoggerFactory.getLogger(IdMServiceImpl.class);
    private final IIDMStore repository;

    public IdMServiceImpl(IIDMStore repository) {
        this.repository = repository;
    }

    @Override
    public List<String> listDomains(String userId) {
        LOG.debug("list Domains for userId: {}", (Object)userId);
        ArrayList<String> domains = new ArrayList<String>();
        try {
            Grants grants = this.repository.getGrants(userId);
            List<Grant> grantList = grants.getGrants();
            for (Grant grant : grantList) {
                Domain domain = this.repository.readDomain(grant.getDomainid());
                domains.add(domain.getName());
            }
            return domains;
        }
        catch (IDMStoreException se) {
            LOG.warn("error getting domains", (Throwable)se);
            return domains;
        }
    }

    @Override
    public List<String> listRoles(String userId, String domainName) {
        LOG.debug("listRoles for userId={} on domain={}", (Object)userId, (Object)domainName);
        ArrayList<String> roles = new ArrayList<String>();
        try {
            String did = null;
            try {
                Domain domain = this.repository.readDomain(domainName);
                if (domain == null) {
                    LOG.debug("DomainName: {} Not found!", (Object)domainName);
                    return roles;
                }
                did = domain.getDomainid();
            }
            catch (IDMStoreException e) {
                return roles;
            }
            Grants grants = this.repository.getGrants(did, userId);
            for (Grant grant : grants.getGrants()) {
                Role role = this.repository.readRole(grant.getRoleid());
                roles.add(role.getName());
            }
            return roles;
        }
        catch (IDMStoreException se) {
            LOG.warn("error getting roles ", (Throwable)se);
            return roles;
        }
    }

    @Override
    public List<String> listUserIDs() throws IDMStoreException {
        List<User> users = this.repository.getUsers().getUsers();
        return users.stream().map(User::getName).collect(Collectors.toList());
    }
}

