/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.osgi.jta.internal;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAException;
import org.jboss.narayana.osgi.jta.internal.OsgiTransactionManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class PlatformTransactionManagerImple
extends JtaTransactionManager {
    private final Map<Transaction, SuspendedResourcesHolder> suspendedResources = new ConcurrentHashMap<Transaction, SuspendedResourcesHolder>();

    public PlatformTransactionManagerImple(OsgiTransactionManager transactionManager) throws XAException {
        super((UserTransaction)transactionManager, (TransactionManager)transactionManager);
        transactionManager.setListener(new OsgiTransactionManager.Listener(){

            @Override
            public void resumed(Transaction transaction) {
                SuspendedResourcesHolder holder = (SuspendedResourcesHolder)PlatformTransactionManagerImple.this.suspendedResources.remove(transaction);
                if (holder != null) {
                    TransactionSynchronizationManager.setActualTransactionActive((boolean)true);
                    TransactionSynchronizationManager.setCurrentTransactionReadOnly((boolean)holder.isReadOnly());
                    TransactionSynchronizationManager.setCurrentTransactionName((String)holder.getName());
                    TransactionSynchronizationManager.initSynchronization();
                    for (TransactionSynchronization synchronization : holder.getSuspendedSynchronizations()) {
                        synchronization.resume();
                        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)synchronization);
                    }
                }
            }

            @Override
            public void suspended(Transaction transaction) {
                if (TransactionSynchronizationManager.isSynchronizationActive()) {
                    List suspendedSynchronizations = TransactionSynchronizationManager.getSynchronizations();
                    for (TransactionSynchronization suspendedSynchronization : suspendedSynchronizations) {
                        suspendedSynchronization.suspend();
                    }
                    TransactionSynchronizationManager.clearSynchronization();
                    String name = TransactionSynchronizationManager.getCurrentTransactionName();
                    TransactionSynchronizationManager.setCurrentTransactionName(null);
                    boolean readOnly = TransactionSynchronizationManager.isCurrentTransactionReadOnly();
                    TransactionSynchronizationManager.setCurrentTransactionReadOnly((boolean)false);
                    TransactionSynchronizationManager.setActualTransactionActive((boolean)false);
                    SuspendedResourcesHolder holder = new SuspendedResourcesHolder(suspendedSynchronizations, name, readOnly);
                    PlatformTransactionManagerImple.this.suspendedResources.put(transaction, holder);
                }
            }
        });
    }

    public static ServiceRegistration register(BundleContext bundleContext, OsgiTransactionManager transactionManager) throws Exception {
        PlatformTransactionManagerImple ptm = new PlatformTransactionManagerImple(transactionManager);
        return bundleContext.registerService(PlatformTransactionManager.class, (Object)ptm, null);
    }

    private static class SuspendedResourcesHolder {
        private final List<TransactionSynchronization> suspendedSynchronizations;
        private final String name;
        private final boolean readOnly;

        public SuspendedResourcesHolder(List<TransactionSynchronization> suspendedSynchronizations, String name, boolean readOnly) {
            this.suspendedSynchronizations = suspendedSynchronizations;
            this.name = name;
            this.readOnly = readOnly;
        }

        public List<TransactionSynchronization> getSuspendedSynchronizations() {
            return this.suspendedSynchronizations;
        }

        public String getName() {
            return this.name;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }
    }
}

