/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jms.oracleaq;

import java.util.Map;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.jms.JMSRuntimeException;
import javax.jms.XAConnectionFactory;
import org.ops4j.pax.jms.service.ConnectionFactoryFactory;

public class OracleAQConnectionFactoryFactory
implements ConnectionFactoryFactory {
    private static final String ORACLE_AQ_FACTORY_CLASS = "oracle.jms.AQjmsFactory";
    private final Class<?> oracleAqConnectionFactoryClass;

    public OracleAQConnectionFactoryFactory() throws ClassNotFoundException {
        ClassLoader classLoader = OracleAQConnectionFactoryFactory.class.getClassLoader();
        this.oracleAqConnectionFactoryClass = classLoader.loadClass(ORACLE_AQ_FACTORY_CLASS);
    }

    public ConnectionFactory createConnectionFactory(Map<String, Object> props) throws JMSRuntimeException {
        String url = (String)props.remove("url");
        String user = (String)props.remove("user");
        String password = (String)props.remove("password");
        if (url == null || user == null || password == null) {
            throw new JMSRuntimeException("The url, user and password properties must be set");
        }
        Properties properties = new Properties();
        properties.setProperty("user", user);
        properties.setProperty("password", password);
        try {
            ConnectionFactory cf = (ConnectionFactory)ConnectionFactory.class.cast(this.oracleAqConnectionFactoryClass.getDeclaredMethod("getConnectionFactory", String.class, Properties.class).invoke(null, url, properties));
            return cf;
        }
        catch (Exception e) {
            throw (JMSRuntimeException)new JMSRuntimeException("Unable to build Oracle AQ ConnectionFactory").initCause((Throwable)e);
        }
    }

    public XAConnectionFactory createXAConnectionFactory(Map<String, Object> props) throws JMSRuntimeException {
        String url = (String)props.remove("url");
        String user = (String)props.remove("user");
        String password = (String)props.remove("password");
        if (url == null || user == null || password == null) {
            throw new JMSRuntimeException("The url, user and password properties must be set");
        }
        Properties properties = new Properties();
        properties.setProperty("user", user);
        properties.setProperty("password", password);
        try {
            XAConnectionFactory xaCf = (XAConnectionFactory)XAConnectionFactory.class.cast(this.oracleAqConnectionFactoryClass.getDeclaredMethod("getXAConnectionFactory", String.class, Properties.class).invoke(null, url, properties));
            return xaCf;
        }
        catch (Exception e) {
            throw (JMSRuntimeException)new JMSRuntimeException("Unable to build Oracle AQ ConnectionFactory").initCause((Throwable)e);
        }
    }
}

